/*
 * Decompiled with CFR 0.152.
 */
package com.backend.Controller;

import com.backend.Entity.Attendance;
import com.backend.Service.AttendanceService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/attendance"})
@CrossOrigin(origins={"http://localhost:3000", "http://fusionmastertech.com", "https://fusionmastertech.com", "http://www.fusionmastertech.com", "https://www.fusionmastertech.com"}, allowCredentials="true")
public class AttendanceController {
    @Autowired
    private AttendanceService attendanceService;

    @GetMapping(value={"/getall"})
    public ResponseEntity<List<Attendance>> getAllAttendances() {
        List attendances = this.attendanceService.getAllAttendances();
        return new ResponseEntity((Object)attendances, (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/get/{id}"})
    public ResponseEntity<Attendance> getAttendanceById(@PathVariable Long id) {
        Attendance attendance = this.attendanceService.getAttendanceById(id);
        return attendance != null ? new ResponseEntity((Object)attendance, (HttpStatusCode)HttpStatus.OK) : new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    @PostMapping(value={"/add"})
    public ResponseEntity<Attendance> saveAttendance(@RequestBody Attendance attendance) {
        Attendance savedAttendance = this.attendanceService.saveAttendance(attendance);
        return new ResponseEntity((Object)savedAttendance, (HttpStatusCode)HttpStatus.CREATED);
    }

    @PutMapping(value={"/update/{id}"})
    public ResponseEntity<Attendance> updateAttendance(@PathVariable Long id, @RequestBody Attendance updatedAttendance) {
        Attendance attendance = this.attendanceService.updateAttendance(id, updatedAttendance);
        return attendance != null ? new ResponseEntity((Object)attendance, (HttpStatusCode)HttpStatus.OK) : new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    @DeleteMapping(value={"delete/{id}"})
    public ResponseEntity<Void> deleteAttendance(@PathVariable Long id) {
        this.attendanceService.deleteAttendanceById(id);
        return ResponseEntity.noContent().build();
    }
}

