/*
 * Decompiled with CFR 0.152.
 */
package com.backend.Controller;

import com.backend.Entity.Customer;
import com.backend.Entity.DatabaseRequest;
import com.backend.Entity.LoginRequest;
import com.backend.Service.CustomerService;
import com.backend.ServiceImpl.DatabaseService;
import jakarta.servlet.http.HttpSession;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/customer"})
@CrossOrigin(origins={"http://localhost:3000", "http://fusionmastertech.com", "https://fusionmastertech.com", "http://www.fusionmastertech.com", "https://www.fusionmastertech.com"}, allowCredentials="true")
public class CustomerController {
    @Autowired
    private CustomerService customerservice;
    @Autowired
    private DatabaseService databaseService;

    @PostMapping(value={"/save"})
    public ResponseEntity<?> saveCustomer(@RequestBody Customer customer) {
        if (this.customerservice.existsByFranchiseId(customer.getFranchiseId())) {
            HashMap<String, String> response = new HashMap<String, String>();
            response.put("message", "Franchise ID already exists");
            return ResponseEntity.status((HttpStatusCode)HttpStatus.CONFLICT).body(response);
        }
        DatabaseRequest dbRequest = new DatabaseRequest();
        dbRequest.setDbName(customer.getDbName());
        dbRequest.setDbUsername(customer.getDbUsername());
        dbRequest.setDbPassword(customer.getDbPassword());
        if (!this.databaseService.createDatabase(dbRequest)) {
            HashMap<String, String> response = new HashMap<String, String>();
            response.put("message", "Failed to create database");
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body(response);
        }
        Customer savedCustomer = this.customerservice.saveCustomer(customer);
        return ResponseEntity.ok((Object)savedCustomer);
    }

    @PostMapping(value={"/login"})
    public ResponseEntity<Map<String, String>> login(@RequestBody LoginRequest request, HttpSession session) {
        Optional customer;
        boolean isAuthenticated = this.customerservice.authenticate(request.getEmail(), request.getPassword());
        if (isAuthenticated && (customer = this.customerservice.findByEmailId(request.getEmail())).isPresent()) {
            session.setAttribute("userEmail", (Object)request.getEmail());
            session.setAttribute("tenantDbName", (Object)((Customer)customer.get()).getDbName());
            HashMap<String, String> response = new HashMap<String, String>();
            response.put("message", "Login successful");
            response.put("tenantDbName", ((Customer)customer.get()).getDbName());
            return new ResponseEntity(response, (HttpStatusCode)HttpStatus.OK);
        }
        return new ResponseEntity(Map.of("message", "Invalid credentials or account inactive"), (HttpStatusCode)HttpStatus.UNAUTHORIZED);
    }

    @PostMapping(value={"/logout"})
    public ResponseEntity<String> logout(HttpSession session) {
        session.invalidate();
        return new ResponseEntity((Object)"Logout successful", (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/getall"})
    public ResponseEntity<List<Customer>> getAllCustomers() {
        List customers = this.customerservice.getAllCustomers();
        return ResponseEntity.ok((Object)customers);
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<Customer> getCustomerById(@PathVariable Long id) {
        Customer customers = this.customerservice.getCustomerById(id);
        if (customers != null) {
            return ResponseEntity.ok((Object)customers);
        }
        return ResponseEntity.notFound().build();
    }

    @PutMapping(value={"update/{id}"})
    ResponseEntity<Customer> updateCustomer(@PathVariable Long id, @RequestBody Customer updatedCustomer) {
        Customer custom = this.customerservice.updateCustomer(id, updatedCustomer);
        if (custom != null) {
            return ResponseEntity.ok((Object)custom);
        }
        return ResponseEntity.notFound().build();
    }

    @DeleteMapping(value={"/delete/{id}"})
    public ResponseEntity<Void> deleteCustomerById(@PathVariable Long id) {
        this.customerservice.deleteCustomerById(id);
        return ResponseEntity.noContent().build();
    }

    @GetMapping(value={"/franchiseName/email/{email}"})
    public ResponseEntity<Map<String, String>> getFirmNameByEmail(@PathVariable String email) {
        Optional franchiseName = this.customerservice.findFirmNameByEmail(email);
        if (franchiseName.isPresent()) {
            HashMap<String, String> response = new HashMap<String, String>();
            response.put("franchiseName", (String)franchiseName.get());
            return ResponseEntity.ok(response);
        }
        return ResponseEntity.notFound().build();
    }

    @GetMapping(value={"/checkFranchiseId/{franchiseId}"})
    public ResponseEntity<Map<String, Boolean>> checkFranchiseIdExists(@PathVariable String franchiseId) {
        boolean exists = this.customerservice.existsByFranchiseId(franchiseId);
        HashMap<String, Boolean> response = new HashMap<String, Boolean>();
        response.put("FranchiseId exists ", exists);
        return ResponseEntity.ok(response);
    }

    @GetMapping(value={"/email/{email}"})
    public ResponseEntity<Customer> getCustomerByEmailId(@PathVariable String email) {
        Optional customer = this.customerservice.findByEmailId(email);
        if (customer.isPresent()) {
            return ResponseEntity.ok((Object)((Customer)customer.get()));
        }
        return ResponseEntity.notFound().build();
    }

    @GetMapping(value={"/check-email"})
    public ResponseEntity<Map<String, Boolean>> checkEmailExists(@RequestParam String email) {
        boolean exists = this.customerservice.existsByEmail(email);
        HashMap<String, Boolean> response = new HashMap<String, Boolean>();
        response.put("emailExists", exists);
        return ResponseEntity.ok(response);
    }

    @PutMapping(value={"/toggle-active/{id}"})
    public ResponseEntity<Map<String, Object>> toggleCustomerActiveStatus(@PathVariable Long id, @RequestParam boolean isActive) {
        Customer updatedCustomer = this.customerservice.toggleActiveStatus(id, isActive);
        if (updatedCustomer != null) {
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("message", "Customer status updated");
            response.put("isActive", updatedCustomer.getIsActive());
            return ResponseEntity.ok(response);
        }
        return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).body(Map.of("message", "Customer not found"));
    }

    @GetMapping(value={"/getallactive"})
    public ResponseEntity<List<Customer>> getAllActiveCustomers() {
        List activeCustomers = this.customerservice.getAllActiveCustomers();
        return ResponseEntity.ok((Object)activeCustomers);
    }

    @GetMapping(value={"/getallinactive"})
    public ResponseEntity<List<Customer>> getAllInactiveCustomers() {
        List inactiveCustomers = this.customerservice.getAllInactiveCustomers();
        return ResponseEntity.ok((Object)inactiveCustomers);
    }

    @GetMapping(value={"/franchise/{franchiseId}"})
    public ResponseEntity<Customer> getCustomerByFranchiseId(@PathVariable String franchiseId) {
        Optional customer = this.customerservice.findByFranchiseId(franchiseId);
        return customer.map(ResponseEntity::ok).orElseGet(() -> ResponseEntity.notFound().build());
    }
}

