/*
 * Decompiled with CFR 0.152.
 */
package com.backend.Controller;

import com.backend.Entity.Department;
import com.backend.Service.DepartmentService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/department"})
@CrossOrigin(origins={"http://localhost:3000", "http://fusionmastertech.com", "https://fusionmastertech.com", "http://www.fusionmastertech.com", "https://www.fusionmastertech.com"}, allowCredentials="true")
public class DepartmentController {
    @Autowired
    private DepartmentService departmentService;

    @PostMapping(value={"/add"})
    public ResponseEntity<Department> createDepartment(@RequestBody Department department) {
        try {
            Department savedDepartment = this.departmentService.saveDepartment(department);
            return new ResponseEntity((Object)savedDepartment, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (IllegalArgumentException e) {
            return new ResponseEntity(null, (HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
    }

    @GetMapping(value={"/getall"})
    public ResponseEntity<List<Department>> getAllDepartments() {
        List departments = this.departmentService.getAllDepartments();
        return new ResponseEntity((Object)departments, (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/get/{id}"})
    public ResponseEntity<Department> getDepartmentById(@PathVariable Long id) {
        try {
            Department department = this.departmentService.getDepartmentById(id);
            return new ResponseEntity((Object)department, (HttpStatusCode)HttpStatus.OK);
        }
        catch (IllegalArgumentException e) {
            return new ResponseEntity(null, (HttpStatusCode)HttpStatus.NOT_FOUND);
        }
    }

    @PutMapping(value={"/update/{id}"})
    public ResponseEntity<Department> updateDepartment(@PathVariable Long id, @RequestBody Department department) {
        try {
            Department updatedDepartment = this.departmentService.updateDepartment(id, department);
            return new ResponseEntity((Object)updatedDepartment, (HttpStatusCode)HttpStatus.OK);
        }
        catch (IllegalArgumentException e) {
            return new ResponseEntity(null, (HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
    }

    @DeleteMapping(value={"/delete/{id}"})
    public ResponseEntity<Void> deleteDepartmentById(@PathVariable Long id) {
        try {
            this.departmentService.deleteDepartmentById(id);
            return new ResponseEntity((HttpStatusCode)HttpStatus.NO_CONTENT);
        }
        catch (Exception e) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
    }
}

