/*
 * Decompiled with CFR 0.152.
 */
package com.backend.Controller;

import com.backend.Entity.FranchisePurchaseOrder;
import com.backend.Service.FranchisePurchaseOrderService;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/franchisepurchaseorder"})
@CrossOrigin(origins={"http://localhost:3000", "http://fusionmastertech.com", "https://fusionmastertech.com", "http://www.fusionmastertech.com", "https://www.fusionmastertech.com"}, allowCredentials="true")
public class FranchisePurchaseOrderController {
    @Autowired
    private FranchisePurchaseOrderService franchisePurchaseOrderService;

    @PostMapping(value={"/save"})
    public ResponseEntity<FranchisePurchaseOrder> createPurchase(@RequestBody FranchisePurchaseOrder purchaseOrder) {
        FranchisePurchaseOrder savedOrder = this.franchisePurchaseOrderService.savePurchaseOrder(purchaseOrder);
        return new ResponseEntity((Object)savedOrder, (HttpStatusCode)HttpStatus.CREATED);
    }

    @GetMapping(value={"/getall"})
    public ResponseEntity<List<FranchisePurchaseOrder>> getAllPurchases() {
        List orders = this.franchisePurchaseOrderService.getAllPurchaseOrders();
        return new ResponseEntity((Object)orders, (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/get/{id}"})
    public ResponseEntity<Optional<FranchisePurchaseOrder>> getPurchaseOrderById(@PathVariable Long id) {
        Optional order = this.franchisePurchaseOrderService.getPurchaseOrderById(id);
        return order.isPresent() ? new ResponseEntity((Object)order, (HttpStatusCode)HttpStatus.OK) : new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    @PutMapping(value={"/update/{id}"})
    public ResponseEntity<FranchisePurchaseOrder> updatePurchaseOrder(@PathVariable Long id, @RequestBody FranchisePurchaseOrder purchaseOrder) {
        FranchisePurchaseOrder updatedOrder = this.franchisePurchaseOrderService.updatePurchaseOrder(id, purchaseOrder);
        return updatedOrder != null ? new ResponseEntity((Object)updatedOrder, (HttpStatusCode)HttpStatus.OK) : new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    @DeleteMapping(value={"/delete/{id}"})
    public ResponseEntity<Void> deletePurchaseOrder(@PathVariable Long id) {
        this.franchisePurchaseOrderService.deletePurchaseOrder(id);
        return new ResponseEntity((HttpStatusCode)HttpStatus.NO_CONTENT);
    }

    @GetMapping(value={"/getAllOrderIds"})
    public ResponseEntity<List<String>> getAllOrderIds() {
        List orderIds = this.franchisePurchaseOrderService.getAllOrderIds();
        return new ResponseEntity((Object)orderIds, (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/getPoDataById/{id}"})
    public ResponseEntity<FranchisePurchaseOrder> getPurchaseOrderByPoId(@PathVariable String id) {
        Optional order = this.franchisePurchaseOrderService.getPurchaseOrderByPoId(id);
        return order.map(value -> new ResponseEntity(value, (HttpStatusCode)HttpStatus.OK)).orElseGet(() -> new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND));
    }

    @GetMapping(value={"/getOrderIdsByStatus/{status}"})
    public ResponseEntity<List<String>> getOrderIdsByStatus(@PathVariable Long status) {
        List orderIds = this.franchisePurchaseOrderService.getPurchaseOrderIdsByStatus(status);
        return new ResponseEntity((Object)orderIds, (HttpStatusCode)HttpStatus.OK);
    }

    @PutMapping(value={"/updateStatus/{id}"})
    public ResponseEntity<FranchisePurchaseOrder> updatePurchaseStatus(@PathVariable Long id, @RequestBody FranchisePurchaseOrder updatedStatus) {
        Optional existingOrder = this.franchisePurchaseOrderService.getPurchaseOrderById(id);
        if (existingOrder.isPresent()) {
            FranchisePurchaseOrder order = (FranchisePurchaseOrder)existingOrder.get();
            order.setStatus(updatedStatus.getStatus());
            FranchisePurchaseOrder updatedOrder = this.franchisePurchaseOrderService.savePurchaseOrder(order);
            return new ResponseEntity((Object)updatedOrder, (HttpStatusCode)HttpStatus.OK);
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    @GetMapping(value={"/getPendingOrders"})
    public ResponseEntity<List<FranchisePurchaseOrder>> getPendingOrders() {
        List orders = this.franchisePurchaseOrderService.getPendingOrders();
        return new ResponseEntity((Object)orders, (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/getAcceptedOrders"})
    public ResponseEntity<List<FranchisePurchaseOrder>> getAcceptedOrders() {
        List orders = this.franchisePurchaseOrderService.getAcceptedOrders();
        return new ResponseEntity((Object)orders, (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/getRejectedOrders"})
    public ResponseEntity<List<FranchisePurchaseOrder>> getRejectedOrders() {
        List orders = this.franchisePurchaseOrderService.getRejectedOrders();
        return new ResponseEntity((Object)orders, (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/getShipOrders"})
    public ResponseEntity<List<FranchisePurchaseOrder>> getShipOrders() {
        List orders = this.franchisePurchaseOrderService.getShipOrders();
        return new ResponseEntity((Object)orders, (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/getTotalShippedItems/{purchaseOrderId}"})
    public ResponseEntity<Long> getTotalShippedItems(@PathVariable String purchaseOrderId) {
        Long totalShippedItems = this.franchisePurchaseOrderService.getTotalShippedItems(purchaseOrderId);
        return ResponseEntity.ok((Object)totalShippedItems);
    }

    @PutMapping(value={"/updateDispatchStatus/{id}"})
    public ResponseEntity<FranchisePurchaseOrder> updateDispatchStatus(@PathVariable Long id, @RequestBody Map<String, String> request) {
        String dispatchStatus = request.get("dispatchStatus");
        if (dispatchStatus == null || dispatchStatus.trim().isEmpty()) {
            return ResponseEntity.badRequest().build();
        }
        FranchisePurchaseOrder updatedOrder = this.franchisePurchaseOrderService.updateDispatchStatus(id, dispatchStatus);
        if (updatedOrder != null) {
            return ResponseEntity.ok((Object)updatedOrder);
        }
        return ResponseEntity.notFound().build();
    }

    @PutMapping(value={"/updateStatusByOrderId/{franchisePurchaseOrderId}"})
    public ResponseEntity<FranchisePurchaseOrder> updateStatusByOrderId(@PathVariable String franchisePurchaseOrderId, @RequestBody Map<String, Long> requestBody) {
        Long newStatus = requestBody.get("status");
        if (newStatus == null) {
            return ResponseEntity.badRequest().build();
        }
        Optional optionalOrder = this.franchisePurchaseOrderService.getPurchaseOrderByPoId(franchisePurchaseOrderId);
        if (optionalOrder.isPresent()) {
            FranchisePurchaseOrder order = (FranchisePurchaseOrder)optionalOrder.get();
            order.setStatus(newStatus);
            FranchisePurchaseOrder updatedOrder = this.franchisePurchaseOrderService.savePurchaseOrder(order);
            return new ResponseEntity((Object)updatedOrder, (HttpStatusCode)HttpStatus.OK);
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
    }
}

