/*
 * Decompiled with CFR 0.152.
 */
package com.backend.Controller;

import com.backend.Entity.Holiday;
import com.backend.Service.HolidayService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/holiday"})
@CrossOrigin(origins={"http://localhost:3000", "http://fusionmastertech.com", "https://fusionmastertech.com", "http://www.fusionmastertech.com", "https://www.fusionmastertech.com"}, allowCredentials="true")
public class HolidayController {
    @Autowired
    private HolidayService holidayService;

    @PostMapping(value={"/add"})
    public ResponseEntity<Holiday> saveHoliday(@RequestBody Holiday holiday) {
        Holiday createdHoliday = this.holidayService.saveHoliday(holiday);
        return new ResponseEntity((Object)createdHoliday, (HttpStatusCode)HttpStatus.CREATED);
    }

    @GetMapping(value={"/getall"})
    public ResponseEntity<List<Holiday>> getAllHolidays() {
        List holidays = this.holidayService.getAllHolidays();
        return new ResponseEntity((Object)holidays, (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/get/{id}"})
    public ResponseEntity<Holiday> getHolidayById(@PathVariable Long id) {
        Holiday holiday = this.holidayService.getHolidayById(id);
        if (holiday != null) {
            return new ResponseEntity((Object)holiday, (HttpStatusCode)HttpStatus.OK);
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    @PutMapping(value={"/update/{id}"})
    public ResponseEntity<Holiday> updateHoliday(@PathVariable Long id, @RequestBody Holiday updatedHoliday) {
        Holiday holiday = this.holidayService.updateHoliday(id, updatedHoliday);
        if (holiday != null) {
            return new ResponseEntity((Object)holiday, (HttpStatusCode)HttpStatus.OK);
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    @DeleteMapping(value={"/delete/{id}"})
    public ResponseEntity<Void> deleteHolidayById(@PathVariable Long id) {
        this.holidayService.deleteHolidayById(id);
        return new ResponseEntity((HttpStatusCode)HttpStatus.NO_CONTENT);
    }
}

