/*
 * Decompiled with CFR 0.152.
 */
package com.backend.Controller;

import com.backend.Entity.PurchaseDIOrder;
import com.backend.Service.PurchaseDIOrderService;
import com.backend.Util.FileUploadUtil;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/purchase-di-order"})
@CrossOrigin(origins={"http://localhost:3000", "http://fusionmastertech.com", "https://fusionmastertech.com", "http://www.fusionmastertech.com", "https://www.fusionmastertech.com"}, allowCredentials="true")
public class PurchaseDIOrderController {
    @Autowired
    private PurchaseDIOrderService purchaseDIOrderService;
    @Autowired
    private FileUploadUtil fileUploadUtil;

    @PostMapping(value={"/save"})
    public ResponseEntity<PurchaseDIOrder> createPurchase(@RequestParam(value="purchaseDIOrder") String purchaseOrderJson, @RequestParam(value="file", required=false) MultipartFile file) {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            PurchaseDIOrder purchaseOrder = (PurchaseDIOrder)objectMapper.readValue(purchaseOrderJson, PurchaseDIOrder.class);
            if (file != null && !file.isEmpty()) {
                String fileName = System.currentTimeMillis() + "_" + file.getOriginalFilename();
                String filePath = this.fileUploadUtil.saveFile(fileName, file);
                purchaseOrder.setFile(filePath);
            }
            PurchaseDIOrder savedOrder = this.purchaseDIOrderService.savePurchaseDIOrder(purchaseOrder);
            return new ResponseEntity((Object)savedOrder, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (IOException e) {
            return new ResponseEntity(null, (HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
    }

    @PutMapping(value={"/update/{id}"})
    public ResponseEntity<PurchaseDIOrder> updatePurchaseOrder(@PathVariable Long id, @RequestParam(value="purchaseDIOrder") String purchaseOrderJson, @RequestParam(value="file", required=false) MultipartFile file) {
        try {
            PurchaseDIOrder existingOrder = this.purchaseDIOrderService.getPurchaseDIOrderById(id).orElse(null);
            if (existingOrder == null) {
                return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
            }
            ObjectMapper objectMapper = new ObjectMapper();
            PurchaseDIOrder updatedOrder = (PurchaseDIOrder)objectMapper.readValue(purchaseOrderJson, PurchaseDIOrder.class);
            updatedOrder.setId(id);
            if (file != null && !file.isEmpty()) {
                String fileName = System.currentTimeMillis() + "_" + file.getOriginalFilename();
                String filePath = this.fileUploadUtil.saveFile(fileName, file);
                updatedOrder.setFile(filePath);
            } else {
                updatedOrder.setFile(existingOrder.getFile());
            }
            PurchaseDIOrder saved = this.purchaseDIOrderService.updatePurchaseDIOrder(id, updatedOrder);
            return new ResponseEntity((Object)saved, (HttpStatusCode)HttpStatus.OK);
        }
        catch (IOException e) {
            return new ResponseEntity(null, (HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
    }

    @GetMapping(value={"/getall"})
    public ResponseEntity<List<PurchaseDIOrder>> getAllPurchases() {
        List orders = this.purchaseDIOrderService.getAllPurchaseDIOrders();
        return new ResponseEntity((Object)orders, (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/get/{id}"})
    public ResponseEntity<Optional<PurchaseDIOrder>> getPurchaseOrderById(@PathVariable Long id) {
        Optional orders = this.purchaseDIOrderService.getPurchaseDIOrderById(id);
        return orders.isPresent() ? new ResponseEntity((Object)orders, (HttpStatusCode)HttpStatus.OK) : new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    @DeleteMapping(value={"/delete/{id}"})
    public ResponseEntity<Void> deletePurchaseOrder(@PathVariable Long id) {
        this.purchaseDIOrderService.deletePurchaseDIOrder(id);
        return new ResponseEntity((HttpStatusCode)HttpStatus.NO_CONTENT);
    }

    @GetMapping(value={"/getAllOrderIds"})
    public ResponseEntity<List<String>> getAllOrderIds() {
        List orderIds = this.purchaseDIOrderService.getAllOrderIds();
        return new ResponseEntity((Object)orderIds, (HttpStatusCode)HttpStatus.OK);
    }
}

