/*
 * Decompiled with CFR 0.152.
 */
package com.backend.Controller;

import com.backend.Entity.LoginRequest;
import com.backend.Entity.User;
import com.backend.Service.UserService;
import jakarta.servlet.http.HttpSession;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/user"})
@CrossOrigin(origins={"http://localhost:3000", "http://fusionmastertech.com", "https://fusionmastertech.com", "http://www.fusionmastertech.com", "https://www.fusionmastertech.com"}, allowCredentials="true")
public class UserController {
    @Autowired
    private UserService userservice;

    @PostMapping(value={"/save"})
    public ResponseEntity<User> saveUser(@RequestBody User user) {
        User savedUser = this.userservice.saveUser(user);
        return new ResponseEntity((Object)savedUser, (HttpStatusCode)HttpStatus.CREATED);
    }

    @PostMapping(value={"/login"})
    public ResponseEntity<String> login(@RequestBody LoginRequest request, HttpSession session) {
        boolean isAuthenticated = this.userservice.authenticate(request.getEmail(), request.getPassword());
        if (isAuthenticated) {
            session.setAttribute("userEmail", (Object)request.getEmail());
            return new ResponseEntity((Object)"Login successful", (HttpStatusCode)HttpStatus.OK);
        }
        return new ResponseEntity((Object)"Invalid credentials or account inactive", (HttpStatusCode)HttpStatus.UNAUTHORIZED);
    }

    @PostMapping(value={"/logout"})
    public ResponseEntity<String> logout(HttpSession session) {
        session.invalidate();
        return new ResponseEntity((Object)"Logout successful", (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/getall"})
    public ResponseEntity<List<User>> getAllUsers() {
        List users = this.userservice.getallusers();
        return new ResponseEntity((Object)users, (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<User> getUserById(@PathVariable Long id) {
        return this.userservice.findById(id).map(user -> new ResponseEntity(user, (HttpStatusCode)HttpStatus.OK)).orElse(new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND));
    }

    @PutMapping(value={"/update/{id}"})
    public ResponseEntity<User> updateUser(@PathVariable Long id, @RequestBody User user) {
        return this.userservice.updateUser(id, user).map(updatedUser -> new ResponseEntity(updatedUser, (HttpStatusCode)HttpStatus.OK)).orElse(new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND));
    }

    @DeleteMapping(value={"/delete/{id}"})
    public ResponseEntity<Void> deleteUser(@PathVariable Long id) {
        boolean isDeleted = this.userservice.deleteUser(id);
        return isDeleted ? new ResponseEntity((HttpStatusCode)HttpStatus.NO_CONTENT) : new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    @GetMapping(value={"/email/{email}"})
    public ResponseEntity<User> getUserWithRolesAndPermissions(@PathVariable String email) {
        try {
            User user = this.userservice.getUserWithRolesAndPermissions(email);
            return user != null ? new ResponseEntity((Object)user, (HttpStatusCode)HttpStatus.OK) : new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        catch (IllegalStateException e) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @GetMapping(value={"/check-email"})
    public ResponseEntity<String> checkEmail(@RequestParam String email) {
        Optional exists = this.userservice.findByEmail(email);
        if (exists.isPresent()) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.OK).body((Object)"Email exists");
        }
        return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).body((Object)"Email does not exist");
    }

    @GetMapping(value={"/username"})
    public Optional<String> getUsername(@RequestParam String email) {
        return this.userservice.getUserName(email);
    }
}

