/*
 * Decompiled with CFR 0.152.
 */
package com.backend.Controller;

import com.backend.Entity.VendorWarrantyClaim;
import com.backend.Service.VendorWarrantyClaimService;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/vendor-warranty-claim"})
@CrossOrigin(origins={"http://localhost:3000", "http://fusionmastertech.com", "https://fusionmastertech.com", "http://www.fusionmastertech.com", "https://www.fusionmastertech.com"}, allowCredentials="true")
public class VendorWarrantyClaimController {
    @Autowired
    private VendorWarrantyClaimService vendorWarrantyClaimService;

    @PostMapping(value={"/save"})
    public ResponseEntity<VendorWarrantyClaim> saveWarrantyClaim(@RequestBody VendorWarrantyClaim vendorWarrantyClaim) {
        try {
            VendorWarrantyClaim savedWarrantyClaim = this.vendorWarrantyClaimService.saveWarrantyClaim(vendorWarrantyClaim);
            return new ResponseEntity((Object)savedWarrantyClaim, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (Exception e) {
            return new ResponseEntity(null, (HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
    }

    @GetMapping(value={"/getall"})
    public ResponseEntity<List<VendorWarrantyClaim>> getAllWarrantyClaims() {
        try {
            List warrantyClaims = this.vendorWarrantyClaimService.getAllWarrantyClaims();
            if (warrantyClaims.isEmpty()) {
                return new ResponseEntity((HttpStatusCode)HttpStatus.NO_CONTENT);
            }
            return new ResponseEntity((Object)warrantyClaims, (HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception e) {
            return new ResponseEntity(null, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @GetMapping(value={"/get/{id}"})
    public ResponseEntity<VendorWarrantyClaim> getWarrantyClaimById(@PathVariable(value="id") Long id) {
        Optional warrantyClaim = this.vendorWarrantyClaimService.getWarrantyClaimById(id);
        return warrantyClaim.map(claim -> new ResponseEntity(claim, (HttpStatusCode)HttpStatus.OK)).orElseGet(() -> new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND));
    }

    @PutMapping(value={"/update/{id}"})
    public ResponseEntity<VendorWarrantyClaim> updateWarrantyClaim(@PathVariable(value="id") Long id, @RequestBody VendorWarrantyClaim vendorWarrantyClaim) {
        try {
            VendorWarrantyClaim updatedWarrantyClaim = this.vendorWarrantyClaimService.updateWarrantyClaim(id, vendorWarrantyClaim);
            return new ResponseEntity((Object)updatedWarrantyClaim, (HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception e) {
            return new ResponseEntity(null, (HttpStatusCode)HttpStatus.NOT_FOUND);
        }
    }

    @DeleteMapping(value={"/delete/{id}"})
    public ResponseEntity<HttpStatus> deleteWarrantyClaim(@PathVariable(value="id") Long id) {
        try {
            this.vendorWarrantyClaimService.deleteWarrantyClaim(id);
            return new ResponseEntity((HttpStatusCode)HttpStatus.NO_CONTENT);
        }
        catch (Exception e) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
    }

    @PutMapping(value={"/updateStatus/{id}"})
    public ResponseEntity<VendorWarrantyClaim> updateWarrantyClaimStatus(@PathVariable(value="id") Long id, @RequestBody Long newStatus) {
        try {
            VendorWarrantyClaim updatedWarrantyClaim = this.vendorWarrantyClaimService.updateWarrantyClaimStatus(id, newStatus);
            return new ResponseEntity((Object)updatedWarrantyClaim, (HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception e) {
            return new ResponseEntity(null, (HttpStatusCode)HttpStatus.NOT_FOUND);
        }
    }

    @GetMapping(value={"/getPendingOrders"})
    public ResponseEntity<List<VendorWarrantyClaim>> getPendingOrders() {
        List pendingOrders = this.vendorWarrantyClaimService.getPendingOrders();
        return new ResponseEntity((Object)pendingOrders, (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/getAcceptedOrders"})
    public ResponseEntity<List<VendorWarrantyClaim>> getAcceptedOrders() {
        List acceptedOrders = this.vendorWarrantyClaimService.getAcceptedOrders();
        return new ResponseEntity((Object)acceptedOrders, (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/getRejectedOrders"})
    public ResponseEntity<List<VendorWarrantyClaim>> getRejectedOrders() {
        List rejectedOrders = this.vendorWarrantyClaimService.getRejectedOrders();
        return new ResponseEntity((Object)rejectedOrders, (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/getShipOrders"})
    public ResponseEntity<List<VendorWarrantyClaim>> getShipOrders() {
        List shipOrders = this.vendorWarrantyClaimService.getShipOrders();
        return new ResponseEntity((Object)shipOrders, (HttpStatusCode)HttpStatus.OK);
    }
}

