/*
 * Decompiled with CFR 0.152.
 */
package com.backend.Entity;

import com.backend.Entity.SaleDIItem;
import com.backend.Entity.ShippingSaleDIDetails;
import com.backend.Entity.StockTransaction;
import com.backend.Service.IdGenerator;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.OneToMany;
import jakarta.persistence.PrePersist;
import jakarta.persistence.Transient;
import java.math.BigDecimal;
import java.util.List;

@Entity
public class SaleDIOrder {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    private String saleDIOrderId;
    private String franchise;
    private String referenceNumber;
    private String addedBy;
    private String saleDate;
    private Long customerId;
    private Long payTermNumber;
    private String payTermType;
    private String location;
    private Long totalItems;
    private BigDecimal netTotalAmount;
    private String discountType;
    private BigDecimal discountAmount;
    private String purchaseTax;
    private BigDecimal taxAmount;
    private String additionalNotes;
    @OneToMany(mappedBy="saleDIOrder", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<SaleDIItem> saleDIItem;
    @OneToMany(mappedBy="saleDIOrder", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<ShippingSaleDIDetails> shippingSaleDIDetails;
    @OneToMany(mappedBy="saleDIOrder", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<StockTransaction> stockTransactions;
    @Transient
    private IdGenerator idGenerator;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getSaleDIOrderId() {
        return this.saleDIOrderId;
    }

    public void setSaleDIOrderId(String saleDIOrderId) {
        this.saleDIOrderId = saleDIOrderId;
    }

    public Long getCustomerId() {
        return this.customerId;
    }

    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }

    public String getFranchise() {
        return this.franchise;
    }

    public void setFranchise(String franchise) {
        this.franchise = franchise;
    }

    public String getReferenceNumber() {
        return this.referenceNumber;
    }

    public void setReferenceNumber(String referenceNumber) {
        this.referenceNumber = referenceNumber;
    }

    public String getAddedBy() {
        return this.addedBy;
    }

    public void setAddedBy(String addedBy) {
        this.addedBy = addedBy;
    }

    public String getSaleDate() {
        return this.saleDate;
    }

    public void setSaleDate(String saleDate) {
        this.saleDate = saleDate;
    }

    public Long getPayTermNumber() {
        return this.payTermNumber;
    }

    public void setPayTermNumber(Long payTermNumber) {
        this.payTermNumber = payTermNumber;
    }

    public String getPayTermType() {
        return this.payTermType;
    }

    public void setPayTermType(String payTermType) {
        this.payTermType = payTermType;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public Long getTotalItems() {
        return this.totalItems;
    }

    public void setTotalItems(Long totalItems) {
        this.totalItems = totalItems;
    }

    public BigDecimal getNetTotalAmount() {
        return this.netTotalAmount;
    }

    public void setNetTotalAmount(BigDecimal netTotalAmount) {
        this.netTotalAmount = netTotalAmount;
    }

    public String getDiscountType() {
        return this.discountType;
    }

    public void setDiscountType(String discountType) {
        this.discountType = discountType;
    }

    public BigDecimal getDiscountAmount() {
        return this.discountAmount;
    }

    public void setDiscountAmount(BigDecimal discountAmount) {
        this.discountAmount = discountAmount;
    }

    public String getPurchaseTax() {
        return this.purchaseTax;
    }

    public void setPurchaseTax(String purchaseTax) {
        this.purchaseTax = purchaseTax;
    }

    public BigDecimal getTaxAmount() {
        return this.taxAmount;
    }

    public void setTaxAmount(BigDecimal taxAmount) {
        this.taxAmount = taxAmount;
    }

    public String getAdditionalNotes() {
        return this.additionalNotes;
    }

    public void setAdditionalNotes(String additionalNotes) {
        this.additionalNotes = additionalNotes;
    }

    public List<SaleDIItem> getSaleDIItem() {
        return this.saleDIItem;
    }

    public void setSaleDIItem(List<SaleDIItem> saleDIItem) {
        this.saleDIItem = saleDIItem;
    }

    public List<ShippingSaleDIDetails> getShippingSaleDIDetails() {
        return this.shippingSaleDIDetails;
    }

    public void setShippingSaleDIDetails(List<ShippingSaleDIDetails> shippingSaleDIDetails) {
        this.shippingSaleDIDetails = shippingSaleDIDetails;
    }

    public void setIdGenerator(IdGenerator idGenerator) {
        this.idGenerator = idGenerator;
    }

    @PrePersist
    private void generateSaleDIOrderId() {
        if (this.saleDIOrderId == null && this.idGenerator != null) {
            this.saleDIOrderId = this.idGenerator.generateSaleDIOrderId();
        }
    }

    public List<StockTransaction> getStockTransactions() {
        return this.stockTransactions;
    }

    public void setStockTransactions(List<StockTransaction> stockTransactions) {
        this.stockTransactions = stockTransactions;
    }
}

