/*
 * Decompiled with CFR 0.152.
 */
package com.backend.ServiceImpl;

import com.backend.Entity.AddExpenses;
import com.backend.Entity.Transaction;
import com.backend.Repository.AddExpensesRepo;
import com.backend.Service.AddExpensesService;
import jakarta.transaction.Transactional;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AddExpensesServiceImpl
implements AddExpensesService {
    @Autowired
    private AddExpensesRepo addExpensesRepo;

    @Transactional
    public AddExpenses saveAddExpenses(AddExpenses addExpenses) {
        if (addExpenses.getTransaction() != null) {
            for (Transaction tx : addExpenses.getTransaction()) {
                tx.setAddExpenses(addExpenses);
            }
        }
        return (AddExpenses)this.addExpensesRepo.save((Object)addExpenses);
    }

    @Transactional
    public AddExpenses updateAddExpenses(Long id, AddExpenses updated) {
        return this.addExpensesRepo.findById((Object)id).map(existing -> {
            updated.setId(existing.getId());
            if (updated.getTransaction() != null) {
                updated.getTransaction().forEach(t -> t.setAddExpenses(updated));
            }
            return (AddExpenses)this.addExpensesRepo.save((Object)updated);
        }).orElseThrow(() -> new RuntimeException("Expense not found with ID: " + id));
    }

    public Optional<AddExpenses> getAddExpensesById(Long id) {
        return this.addExpensesRepo.findById((Object)id);
    }

    public List<AddExpenses> getAllAddExpenses() {
        return this.addExpensesRepo.findAll();
    }

    public void deleteAddExpenses(Long id) {
        this.addExpensesRepo.deleteById((Object)id);
    }
}

