/*
 * Decompiled with CFR 0.152.
 */
package com.backend.ServiceImpl;

import com.backend.Entity.PaymentAccount;
import com.backend.Entity.PurchasePoItem;
import com.backend.Entity.PurchasePoOrder;
import com.backend.Entity.ShippingPoDetails;
import com.backend.Entity.StockTransaction;
import com.backend.Entity.Transaction;
import com.backend.Repository.PaymentAccountRepo;
import com.backend.Repository.PurchasePoOrderRepo;
import com.backend.Service.PurchasePoOrderService;
import jakarta.transaction.Transactional;
import java.math.BigDecimal;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PurchasePoOrderServiceImpl
implements PurchasePoOrderService {
    @Autowired
    private PurchasePoOrderRepo purchaseOrderRepo;
    @Autowired
    private PaymentAccountRepo paymentAccountRepo;

    @Transactional
    public PurchasePoOrder savePurchasePoOrder(PurchasePoOrder purchasePoOrder) {
        if (purchasePoOrder.getPurchasePoItem() != null) {
            for (PurchasePoItem item : purchasePoOrder.getPurchasePoItem()) {
                item.setPurchasePoOrder(purchasePoOrder);
            }
        }
        if (purchasePoOrder.getTransaction() != null) {
            for (Transaction transaction : purchasePoOrder.getTransaction()) {
                BigDecimal previousBalance;
                transaction.setPurchasePoOrder(purchasePoOrder);
                if (transaction.getPaymentAccount() == null && transaction.getPaymentAccountId() != null) {
                    PaymentAccount paymentAccount = (PaymentAccount)this.paymentAccountRepo.findById((Object)transaction.getPaymentAccountId()).orElseThrow(() -> new RuntimeException("Payment Account not found for ID: " + transaction.getPaymentAccountId()));
                    transaction.setPaymentAccount(paymentAccount);
                }
                if (transaction.getPaymentAccount() == null) {
                    throw new RuntimeException("Transaction must be associated with a valid Payment Account.");
                }
                BigDecimal newBalance = previousBalance = transaction.getPaymentAccount().getBalance() != null ? transaction.getPaymentAccount().getBalance() : BigDecimal.ZERO;
                switch (transaction.getTransactionType().toLowerCase()) {
                    case "deposit": 
                    case "sale": 
                    case "opening_balance": {
                        newBalance = previousBalance.add(transaction.getAmount());
                        break;
                    }
                    case "purchase": 
                    case "expense": {
                        newBalance = previousBalance.subtract(transaction.getAmount());
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unknown transaction type: " + transaction.getTransactionType());
                    }
                }
                transaction.setBalance(newBalance);
                transaction.getPaymentAccount().setBalance(newBalance);
                this.paymentAccountRepo.save((Object)transaction.getPaymentAccount());
            }
        }
        if (purchasePoOrder.getShippingPoDetails() != null) {
            for (ShippingPoDetails ship : purchasePoOrder.getShippingPoDetails()) {
                ship.setPurchasePoOrder(purchasePoOrder);
            }
        }
        if (purchasePoOrder.getStockTransactions() != null) {
            for (StockTransaction stock : purchasePoOrder.getStockTransactions()) {
                stock.setPurchasePoOrder(purchasePoOrder);
            }
        }
        return (PurchasePoOrder)this.purchaseOrderRepo.save((Object)purchasePoOrder);
    }

    public List<PurchasePoOrder> getAllPurchasePoOrders() {
        return this.purchaseOrderRepo.findAll();
    }

    public Optional<PurchasePoOrder> getPurchasePoOrderById(Long id) {
        return this.purchaseOrderRepo.findById((Object)id);
    }

    public PurchasePoOrder updatePurchasePoOrder(Long id, PurchasePoOrder updatedPurchasePoOrder) {
        Optional existingOrderOptional = this.purchaseOrderRepo.findById((Object)id);
        if (existingOrderOptional.isPresent()) {
            PurchasePoOrder existingOrder = (PurchasePoOrder)existingOrderOptional.get();
            existingOrder.setStatus(updatedPurchasePoOrder.getStatus());
            existingOrder.setVendor(updatedPurchasePoOrder.getVendor());
            existingOrder.setAddedBy(updatedPurchasePoOrder.getAddedBy());
            existingOrder.setOrderedBy(updatedPurchasePoOrder.getOrderedBy());
            existingOrder.setReferenceNumber(updatedPurchasePoOrder.getReferenceNumber());
            existingOrder.setPurchaseReferenceNumber(updatedPurchasePoOrder.getPurchaseReferenceNumber());
            existingOrder.setOrderDate(updatedPurchasePoOrder.getOrderDate());
            existingOrder.setPurchaseDate(updatedPurchasePoOrder.getPurchaseDate());
            existingOrder.setPayTermNumber(updatedPurchasePoOrder.getPayTermNumber());
            existingOrder.setPayTermType(updatedPurchasePoOrder.getPayTermType());
            existingOrder.setLocation(updatedPurchasePoOrder.getLocation());
            existingOrder.setFile(updatedPurchasePoOrder.getFile());
            existingOrder.setTotalItems(updatedPurchasePoOrder.getTotalItems());
            existingOrder.setNetTotalAmount(updatedPurchasePoOrder.getNetTotalAmount());
            existingOrder.setDiscountType(updatedPurchasePoOrder.getDiscountType());
            existingOrder.setDiscountAmount(updatedPurchasePoOrder.getDiscountAmount());
            existingOrder.setPurchaseTax(updatedPurchasePoOrder.getPurchaseTax());
            existingOrder.setTaxAmount(updatedPurchasePoOrder.getTaxAmount());
            existingOrder.setAdditionalNotes(updatedPurchasePoOrder.getAdditionalNotes());
            if (updatedPurchasePoOrder.getPurchasePoItem() != null) {
                existingOrder.getPurchasePoItem().clear();
                for (PurchasePoItem item : updatedPurchasePoOrder.getPurchasePoItem()) {
                    item.setPurchasePoOrder(existingOrder);
                    existingOrder.getPurchasePoItem().add(item);
                }
            }
            if (updatedPurchasePoOrder.getShippingPoDetails() != null) {
                existingOrder.getShippingPoDetails().clear();
                for (ShippingPoDetails shippingDetails : updatedPurchasePoOrder.getShippingPoDetails()) {
                    shippingDetails.setPurchasePoOrder(existingOrder);
                    existingOrder.getShippingPoDetails().add(shippingDetails);
                }
            }
            if (updatedPurchasePoOrder.getTransaction() != null) {
                existingOrder.getTransaction().clear();
                for (Transaction transaction : updatedPurchasePoOrder.getTransaction()) {
                    BigDecimal previousBalance;
                    transaction.setPurchasePoOrder(existingOrder);
                    if (transaction.getPaymentAccountId() == null) {
                        throw new RuntimeException("Payment Account ID is required for transactions.");
                    }
                    PaymentAccount paymentAccount = (PaymentAccount)this.paymentAccountRepo.findById((Object)transaction.getPaymentAccountId()).orElseThrow(() -> new RuntimeException("Payment Account not found with ID: " + transaction.getPaymentAccountId()));
                    transaction.setPaymentAccount(paymentAccount);
                    BigDecimal newBalance = previousBalance = paymentAccount.getBalance() != null ? paymentAccount.getBalance() : BigDecimal.ZERO;
                    switch (transaction.getTransactionType().toLowerCase()) {
                        case "deposit": 
                        case "sale": 
                        case "opening_balance": {
                            newBalance = previousBalance.add(transaction.getAmount());
                            break;
                        }
                        case "purchase": 
                        case "expense": {
                            newBalance = previousBalance.subtract(transaction.getAmount());
                            break;
                        }
                        default: {
                            throw new RuntimeException("Unknown transaction type: " + transaction.getTransactionType());
                        }
                    }
                    transaction.setBalance(newBalance);
                    paymentAccount.setBalance(newBalance);
                    this.paymentAccountRepo.save((Object)paymentAccount);
                    existingOrder.getTransaction().add(transaction);
                }
            }
            if (updatedPurchasePoOrder.getStockTransactions() != null) {
                existingOrder.getStockTransactions().clear();
                for (StockTransaction transactions : updatedPurchasePoOrder.getStockTransactions()) {
                    transactions.setPurchasePoOrder(existingOrder);
                    existingOrder.getStockTransactions().add(transactions);
                }
            }
            return (PurchasePoOrder)this.purchaseOrderRepo.save((Object)existingOrder);
        }
        return null;
    }

    public void deletePurchasePoOrder(Long id) {
        if (this.purchaseOrderRepo.existsById((Object)id)) {
            this.purchaseOrderRepo.deleteById((Object)id);
        }
    }

    public List<String> getAllOrderIds() {
        return null;
    }
}

