/*
 * Decompiled with CFR 0.152.
 */
package com.backend.ServiceImpl;

import com.backend.Entity.Purchase;
import com.backend.Entity.PurchaseItem;
import com.backend.Entity.PurchasePaymentMethod;
import com.backend.Entity.ShippingDetails;
import com.backend.Repository.PurchaseItemRepo;
import com.backend.Repository.PurchasePaymentMethodRepo;
import com.backend.Repository.PurchaseRepo;
import com.backend.Repository.ShippingDetailsRepo;
import com.backend.Service.PurchaseService;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class PurchaseServiceImpl
implements PurchaseService {
    @Autowired
    private PurchaseRepo purchaseRepository;
    @Autowired
    private PurchasePaymentMethodRepo purchasePaymentMethodRepository;
    @Autowired
    private ShippingDetailsRepo shippingDetailsRepository;
    @Autowired
    private PurchaseItemRepo purchaseItemRepository;

    public Purchase savePurchase(Purchase purchase) {
        List purchaseItems;
        ShippingDetails shippingDetails;
        PurchasePaymentMethod paymentMethod = purchase.getPurchasePaymentMethod();
        if (paymentMethod != null) {
            this.purchasePaymentMethodRepository.save((Object)paymentMethod);
        }
        if ((shippingDetails = purchase.getShippingDetails()) != null) {
            this.shippingDetailsRepository.save((Object)shippingDetails);
        }
        if ((purchaseItems = purchase.getPurchaseItems()) != null) {
            for (PurchaseItem item : purchaseItems) {
                item.setPurchase(purchase);
                this.purchaseItemRepository.save((Object)item);
            }
        }
        return (Purchase)this.purchaseRepository.save((Object)purchase);
    }

    @Transactional
    public Purchase updatePurchase(Long id, Purchase purchaseDetails) {
        Optional existingPurchaseOpt = this.purchaseRepository.findById((Object)id);
        if (existingPurchaseOpt.isPresent()) {
            List purchaseItems;
            List existingItems;
            ShippingDetails shippingDetails;
            Purchase existingPurchase = (Purchase)existingPurchaseOpt.get();
            existingPurchase.setVendor(purchaseDetails.getVendor());
            existingPurchase.setReferenceNumber(purchaseDetails.getReferenceNumber());
            existingPurchase.setStatus(purchaseDetails.getStatus());
            existingPurchase.setAddedBy(purchaseDetails.getAddedBy());
            existingPurchase.setPurchaseDate(purchaseDetails.getPurchaseDate());
            existingPurchase.setLocation(purchaseDetails.getLocation());
            existingPurchase.setPayTermNumber(purchaseDetails.getPayTermNumber());
            existingPurchase.setPayTermType(purchaseDetails.getPayTermType());
            existingPurchase.setFile(purchaseDetails.getFile());
            existingPurchase.setTotalItems(purchaseDetails.getTotalItems());
            existingPurchase.setNetTotalAmount(purchaseDetails.getNetTotalAmount());
            existingPurchase.setDiscountType(purchaseDetails.getDiscountType());
            existingPurchase.setDiscountAmount(purchaseDetails.getDiscountAmount());
            existingPurchase.setPurchaseTax(purchaseDetails.getPurchaseTax());
            existingPurchase.setTaxAmount(purchaseDetails.getTaxAmount());
            existingPurchase.setAdditionalNotes(purchaseDetails.getAdditionalNotes());
            PurchasePaymentMethod paymentMethod = purchaseDetails.getPurchasePaymentMethod();
            if (paymentMethod != null) {
                existingPurchase.setPurchasePaymentMethod(paymentMethod);
                this.purchasePaymentMethodRepository.save((Object)paymentMethod);
            }
            if ((shippingDetails = purchaseDetails.getShippingDetails()) != null) {
                existingPurchase.setShippingDetails(shippingDetails);
                this.shippingDetailsRepository.save((Object)shippingDetails);
            }
            if ((existingItems = existingPurchase.getPurchaseItems()) != null) {
                for (PurchaseItem existingItem : existingItems) {
                    this.purchaseItemRepository.delete((Object)existingItem);
                }
                existingPurchase.getPurchaseItems().clear();
            }
            if ((purchaseItems = purchaseDetails.getPurchaseItems()) != null) {
                for (PurchaseItem item : purchaseItems) {
                    item.setPurchase(existingPurchase);
                    this.purchaseItemRepository.save((Object)item);
                    existingPurchase.getPurchaseItems().add(item);
                }
            }
            return (Purchase)this.purchaseRepository.save((Object)existingPurchase);
        }
        throw new RuntimeException("Purchase not found for id: " + id);
    }

    public List<Purchase> getAllPurchases() {
        return this.purchaseRepository.findAll();
    }

    public Optional<Purchase> getPurchaseById(Long id) {
        return this.purchaseRepository.findById((Object)id);
    }

    public void deletePurchase(Long id) {
        this.purchaseRepository.deleteById((Object)id);
    }
}

