/*
 * Decompiled with CFR 0.152.
 */
package com.backend.ServiceImpl;

import com.backend.Entity.SaleSoItem;
import com.backend.Entity.SaleSoOrder;
import com.backend.Entity.ShippingSoDetails;
import com.backend.Entity.StockTransaction;
import com.backend.Repository.SaleSoOrderRepo;
import com.backend.Service.SaleSoOrderService;
import jakarta.transaction.Transactional;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class SaleSoOrderServiceImpl
implements SaleSoOrderService {
    @Autowired
    SaleSoOrderRepo saleSoOrderRepo;

    public SaleSoOrder saveSaleSooOrder(SaleSoOrder saleSoOrder) {
        if (saleSoOrder.getSaleSoItem() != null) {
            for (SaleSoItem item : saleSoOrder.getSaleSoItem()) {
                item.setSaleSoOrder(saleSoOrder);
            }
        }
        if (saleSoOrder.getShippingSoDetails() != null) {
            for (ShippingSoDetails ship : saleSoOrder.getShippingSoDetails()) {
                ship.setSaleSoOrder(saleSoOrder);
            }
        }
        if (saleSoOrder.getStockTransactions() != null) {
            for (StockTransaction stock : saleSoOrder.getStockTransactions()) {
                stock.setSaleSoOrder(saleSoOrder);
            }
        }
        return (SaleSoOrder)this.saleSoOrderRepo.save((Object)saleSoOrder);
    }

    public List<SaleSoOrder> getAllSaleSoOrders() {
        return this.saleSoOrderRepo.findAll();
    }

    public Optional<SaleSoOrder> getSaleSoOrderById(Long id) {
        return this.saleSoOrderRepo.findById((Object)id);
    }

    @Transactional
    public SaleSoOrder updateSaleSoOrder(Long id, SaleSoOrder updatedSaleSoOrder) {
        Optional existingOrderOptional = this.saleSoOrderRepo.findById((Object)id);
        if (existingOrderOptional.isPresent()) {
            SaleSoOrder existingOrder = (SaleSoOrder)existingOrderOptional.get();
            existingOrder.setOrderId(updatedSaleSoOrder.getOrderId());
            existingOrder.setOrderRefernceNumber(updatedSaleSoOrder.getOrderRefernceNumber());
            existingOrder.setReferenceNumber(updatedSaleSoOrder.getReferenceNumber());
            existingOrder.setFranchise(updatedSaleSoOrder.getFranchise());
            existingOrder.setFranchiseId(updatedSaleSoOrder.getFranchiseId());
            existingOrder.setCustomerId(updatedSaleSoOrder.getCustomerId());
            existingOrder.setOrderedBy(updatedSaleSoOrder.getOrderedBy());
            existingOrder.setAddedBy(updatedSaleSoOrder.getAddedBy());
            existingOrder.setOrderDate(updatedSaleSoOrder.getOrderDate());
            existingOrder.setSaleDate(updatedSaleSoOrder.getSaleDate());
            existingOrder.setPayTermNumber(updatedSaleSoOrder.getPayTermNumber());
            existingOrder.setPayTermType(updatedSaleSoOrder.getPayTermType());
            existingOrder.setLocation(updatedSaleSoOrder.getLocation());
            existingOrder.setNetTotalAmount(updatedSaleSoOrder.getNetTotalAmount());
            existingOrder.setDiscountType(updatedSaleSoOrder.getDiscountType());
            existingOrder.setDiscountAmount(updatedSaleSoOrder.getDiscountAmount());
            existingOrder.setPurchaseTax(updatedSaleSoOrder.getPurchaseTax());
            existingOrder.setTaxAmount(updatedSaleSoOrder.getTaxAmount());
            existingOrder.setTotalItems(updatedSaleSoOrder.getTotalItems());
            existingOrder.setAdditionalNotes(updatedSaleSoOrder.getAdditionalNotes());
            if (updatedSaleSoOrder.getSaleSoItem() != null) {
                existingOrder.getSaleSoItem().clear();
                for (SaleSoItem item : updatedSaleSoOrder.getSaleSoItem()) {
                    item.setSaleSoOrder(existingOrder);
                    existingOrder.getSaleSoItem().add(item);
                }
            }
            if (updatedSaleSoOrder.getShippingSoDetails() != null) {
                existingOrder.getShippingSoDetails().clear();
                for (ShippingSoDetails ship : updatedSaleSoOrder.getShippingSoDetails()) {
                    ship.setSaleSoOrder(existingOrder);
                    existingOrder.getShippingSoDetails().add(ship);
                }
            }
            if (updatedSaleSoOrder.getStockTransactions() != null) {
                existingOrder.getStockTransactions().clear();
                for (StockTransaction stock : updatedSaleSoOrder.getStockTransactions()) {
                    stock.setSaleSoOrder(existingOrder);
                    existingOrder.getStockTransactions().add(stock);
                }
            }
            return (SaleSoOrder)this.saleSoOrderRepo.save((Object)existingOrder);
        }
        return null;
    }

    public void deleteSaleSoOrder(Long id) {
        if (this.saleSoOrderRepo.existsById((Object)id)) {
            this.saleSoOrderRepo.deleteById((Object)id);
        }
    }

    public List<String> getAllOrderIds() {
        return null;
    }

    public String getNextReferenceNumber() {
        List results = this.saleSoOrderRepo.findTopOrderByReferenceNumber((Pageable)PageRequest.of((int)0, (int)1));
        if (!results.isEmpty()) {
            String lastRef = ((SaleSoOrder)results.get(0)).getReferenceNumber();
            try {
                String numberPart = lastRef.replaceAll("\\D+", "");
                int nextNumber = Integer.parseInt(numberPart) + 1;
                return "FUMASL" + nextNumber;
            }
            catch (NumberFormatException e) {
                return "FUMASL1";
            }
        }
        return "FUMASL1";
    }
}

