/*
 * Decompiled with CFR 0.152.
 */
package com.backend.ServiceImpl;

import com.backend.Entity.Target;
import com.backend.Repository.TargetRepo;
import com.backend.Service.TargetService;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TargetServiceImpl
implements TargetService {
    private final TargetRepo targetRepo;

    @Autowired
    public TargetServiceImpl(TargetRepo targetRepo) {
        this.targetRepo = targetRepo;
    }

    public Target saveTarget(Target target) {
        return (Target)this.targetRepo.save((Object)target);
    }

    public List<Target> getAllTargets() {
        return this.targetRepo.findAll();
    }

    public Target updateTarget(Long id, Target updatedTarget) {
        Optional targetOptional = this.targetRepo.findById((Object)id);
        if (targetOptional.isPresent()) {
            Target existingTarget = (Target)targetOptional.get();
            existingTarget.setEmployee(updatedTarget.getEmployee());
            existingTarget.setTotalAmountFrom(updatedTarget.getTotalAmountFrom());
            existingTarget.setTotalAmountTo(updatedTarget.getTotalAmountTo());
            existingTarget.setCommisionPercent(updatedTarget.getCommisionPercent());
            return (Target)this.targetRepo.save((Object)existingTarget);
        }
        return null;
    }

    public Target getTargetById(Long id) {
        return this.targetRepo.findById((Object)id).orElse(null);
    }

    public boolean deleteTargetById(Long id) {
        Optional targetOptional = this.targetRepo.findById((Object)id);
        if (targetOptional.isPresent()) {
            this.targetRepo.deleteById((Object)id);
            return true;
        }
        return false;
    }
}

