/*
 * Decompiled with CFR 0.152.
 */
package com.backend.Controller;

import com.backend.Entity.AddLeave;
import com.backend.Service.AddLeaveService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/add-leave"})
@CrossOrigin(origins={"http://localhost:3000", "http://fusionmastertech.com", "https://fusionmastertech.com", "http://www.fusionmastertech.com", "https://www.fusionmastertech.com"}, allowCredentials="true")
public class AddLeaveController {
    @Autowired
    private AddLeaveService addLeaveService;

    @PostMapping(value={"/add"})
    public ResponseEntity<AddLeave> addLeave(@RequestBody AddLeave addLeave) {
        AddLeave savedLeave = this.addLeaveService.saveLeave(addLeave);
        return new ResponseEntity((Object)savedLeave, (HttpStatusCode)HttpStatus.CREATED);
    }

    @GetMapping(value={"/getall"})
    public ResponseEntity<List<AddLeave>> getAllLeaves() {
        List leaves = this.addLeaveService.getAllLeaves();
        return new ResponseEntity((Object)leaves, (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/get/{id}"})
    public ResponseEntity<AddLeave> getLeaveById(@PathVariable Long id) {
        AddLeave leave = this.addLeaveService.getLeaveById(id);
        if (leave != null) {
            return new ResponseEntity((Object)leave, (HttpStatusCode)HttpStatus.OK);
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    @PutMapping(value={"/update/{id}"})
    public ResponseEntity<AddLeave> updateLeave(@PathVariable Long id, @RequestBody AddLeave updatedLeave) {
        AddLeave leave = this.addLeaveService.updateLeave(id, updatedLeave);
        if (leave != null) {
            return new ResponseEntity((Object)leave, (HttpStatusCode)HttpStatus.OK);
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    @DeleteMapping(value={"/delete/{id}"})
    public ResponseEntity<Void> deleteLeave(@PathVariable Long id) {
        this.addLeaveService.deleteLeaveById(id);
        return new ResponseEntity((HttpStatusCode)HttpStatus.NO_CONTENT);
    }
}

