/*
 * Decompiled with CFR 0.152.
 */
package com.backend.Controller;

import com.backend.Entity.Brands;
import com.backend.Service.BrandsService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/brands"})
@CrossOrigin(origins={"http://localhost:3000", "http://fusionmastertech.com", "https://fusionmastertech.com", "http://www.fusionmastertech.com", "https://www.fusionmastertech.com"}, allowCredentials="true")
public class BrandsController {
    @Autowired
    private BrandsService brandsService;

    @PostMapping(value={"/save"})
    public ResponseEntity<Brands> saveBrand(@RequestBody Brands brand) {
        Brands savedBrand = this.brandsService.saveBrands(brand);
        return new ResponseEntity((Object)savedBrand, (HttpStatusCode)HttpStatus.CREATED);
    }

    @PutMapping(value={"/update/{id}"})
    public ResponseEntity<Brands> updateBrand(@PathVariable Long id, @RequestBody Brands brand) {
        Brands existingBrand = this.brandsService.getById(id);
        if (existingBrand != null) {
            brand.setId(id);
            Brands updatedBrand = this.brandsService.saveBrands(brand);
            return new ResponseEntity((Object)updatedBrand, (HttpStatusCode)HttpStatus.OK);
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<Brands> getById(@PathVariable Long id) {
        Brands brand = this.brandsService.getById(id);
        if (brand != null) {
            return new ResponseEntity((Object)brand, (HttpStatusCode)HttpStatus.OK);
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    @GetMapping(value={"/getall"})
    public ResponseEntity<List<Brands>> getAllBrands() {
        List brandsList = this.brandsService.getAllBrands();
        return new ResponseEntity((Object)brandsList, (HttpStatusCode)HttpStatus.OK);
    }

    @DeleteMapping(value={"/delete/{id}"})
    public ResponseEntity<Void> deleteById(@PathVariable Long id) {
        Brands brand = this.brandsService.getById(id);
        if (brand != null) {
            this.brandsService.deleteById(id);
            return new ResponseEntity((HttpStatusCode)HttpStatus.NO_CONTENT);
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
    }
}

