/*
 * Decompiled with CFR 0.152.
 */
package com.backend.Controller;

import Exceptions.ResourceNotFoundException;
import com.backend.Entity.Categories;
import com.backend.Service.CategoriesService;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/categories"})
@CrossOrigin(origins={"http://localhost:3000", "http://fusionmastertech.com", "https://fusionmastertech.com", "http://www.fusionmastertech.com", "https://www.fusionmastertech.com"}, allowCredentials="true")
public class CategoriesController {
    @Autowired
    private CategoriesService categoriesService;

    @PostMapping(value={"/save"})
    public ResponseEntity<Categories> createCategory(@RequestBody Categories categories) {
        try {
            Categories savedCategory = this.categoriesService.saveCategories(categories);
            return new ResponseEntity((Object)savedCategory, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (Exception e) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
    }

    @GetMapping(value={"/getall"})
    public ResponseEntity<List<Categories>> getAllCategories() {
        List categoriesList = this.categoriesService.getAll();
        return new ResponseEntity((Object)categoriesList, (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<Categories> getCategoryById(@PathVariable(value="id") Long id) {
        Optional category = this.categoriesService.getById(id);
        return category.map(c -> new ResponseEntity(c, (HttpStatusCode)HttpStatus.OK)).orElse(new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND));
    }

    @PutMapping(value={"/update/{id}"})
    public ResponseEntity<Categories> updateCategory(@PathVariable(value="id") Long id, @RequestBody Categories updatedCategory) {
        try {
            Categories savedCategory = this.categoriesService.updateCategory(id, updatedCategory);
            return new ResponseEntity((Object)savedCategory, (HttpStatusCode)HttpStatus.OK);
        }
        catch (ResourceNotFoundException e) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
    }

    @DeleteMapping(value={"/delete/{id}"})
    public ResponseEntity<Void> deleteCategory(@PathVariable(value="id") Long id) {
        try {
            this.categoriesService.deleteById(id);
            return new ResponseEntity((HttpStatusCode)HttpStatus.NO_CONTENT);
        }
        catch (ResourceNotFoundException e) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
    }
}

