/*
 * Decompiled with CFR 0.152.
 */
package com.backend.Controller;

import com.backend.Entity.FranchiseWarrantyClaim;
import com.backend.Service.FranchiseWarrantyClaimService;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/franchise-warranty-claim"})
@CrossOrigin(origins={"http://localhost:3000", "http://fusionmastertech.com", "https://fusionmastertech.com", "http://www.fusionmastertech.com", "https://www.fusionmastertech.com"}, allowCredentials="true")
public class FranchiseWarrantyClaimController {
    @Autowired
    private FranchiseWarrantyClaimService franchiseWarrantyClaimService;

    @PostMapping(value={"/save"})
    public ResponseEntity<FranchiseWarrantyClaim> saveWarrantyClaim(@RequestBody FranchiseWarrantyClaim claim) {
        try {
            FranchiseWarrantyClaim savedClaim = this.franchiseWarrantyClaimService.saveWarrantyClaim(claim);
            return new ResponseEntity((Object)savedClaim, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (Exception e) {
            return new ResponseEntity(null, (HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
    }

    @GetMapping(value={"/getall"})
    public ResponseEntity<List<FranchiseWarrantyClaim>> getAllWarrantyClaims() {
        try {
            List claims = this.franchiseWarrantyClaimService.getAllWarrantyClaims();
            if (claims.isEmpty()) {
                return new ResponseEntity((HttpStatusCode)HttpStatus.NO_CONTENT);
            }
            return new ResponseEntity((Object)claims, (HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception e) {
            return new ResponseEntity(null, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @GetMapping(value={"/get/{id}"})
    public ResponseEntity<FranchiseWarrantyClaim> getWarrantyClaimById(@PathVariable(value="id") Long id) {
        Optional claim = this.franchiseWarrantyClaimService.getWarrantyClaimById(id);
        return claim.map(c -> new ResponseEntity(c, (HttpStatusCode)HttpStatus.OK)).orElseGet(() -> new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND));
    }

    @PutMapping(value={"/update/{id}"})
    public ResponseEntity<FranchiseWarrantyClaim> updateWarrantyClaim(@PathVariable(value="id") Long id, @RequestBody FranchiseWarrantyClaim claim) {
        try {
            FranchiseWarrantyClaim updatedClaim = this.franchiseWarrantyClaimService.updateWarrantyClaim(id, claim);
            return new ResponseEntity((Object)updatedClaim, (HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception e) {
            return new ResponseEntity(null, (HttpStatusCode)HttpStatus.NOT_FOUND);
        }
    }

    @DeleteMapping(value={"/delete/{id}"})
    public ResponseEntity<HttpStatus> deleteWarrantyClaim(@PathVariable(value="id") Long id) {
        try {
            this.franchiseWarrantyClaimService.deleteWarrantyClaim(id);
            return new ResponseEntity((HttpStatusCode)HttpStatus.NO_CONTENT);
        }
        catch (Exception e) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
    }

    @PutMapping(value={"/updateStatus/{id}"})
    public ResponseEntity<FranchiseWarrantyClaim> updateWarrantyClaimStatus(@PathVariable(value="id") Long id, @RequestBody Long newStatus) {
        try {
            FranchiseWarrantyClaim updatedClaim = this.franchiseWarrantyClaimService.updateWarrantyClaimStatus(id, newStatus);
            return new ResponseEntity((Object)updatedClaim, (HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception e) {
            return new ResponseEntity(null, (HttpStatusCode)HttpStatus.NOT_FOUND);
        }
    }

    @GetMapping(value={"/getPendingOrders"})
    public ResponseEntity<List<FranchiseWarrantyClaim>> getPendingOrders() {
        List pending = this.franchiseWarrantyClaimService.getPendingOrders();
        return new ResponseEntity((Object)pending, (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/getAcceptedOrders"})
    public ResponseEntity<List<FranchiseWarrantyClaim>> getAcceptedOrders() {
        List accepted = this.franchiseWarrantyClaimService.getAcceptedOrders();
        return new ResponseEntity((Object)accepted, (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/getRejectedOrders"})
    public ResponseEntity<List<FranchiseWarrantyClaim>> getRejectedOrders() {
        List rejected = this.franchiseWarrantyClaimService.getRejectedOrders();
        return new ResponseEntity((Object)rejected, (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/getShipOrders"})
    public ResponseEntity<List<FranchiseWarrantyClaim>> getShipOrders() {
        List shipped = this.franchiseWarrantyClaimService.getShipOrders();
        return new ResponseEntity((Object)shipped, (HttpStatusCode)HttpStatus.OK);
    }
}

