/*
 * Decompiled with CFR 0.152.
 */
package com.backend.Controller;

import com.backend.Entity.Permission;
import com.backend.Service.PermissionService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/permissions"})
@CrossOrigin(origins={"http://localhost:3000", "http://fusionmastertech.com", "https://fusionmastertech.com", "http://www.fusionmastertech.com", "https://www.fusionmastertech.com"}, allowCredentials="true")
public class PermissionController {
    @Autowired
    private PermissionService permissionService;

    public PermissionController(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public PermissionController() {
    }

    @PostMapping(value={"/save"})
    public ResponseEntity<Permission> savePermission(@RequestBody Permission permission) {
        Permission savedPermission = this.permissionService.savePermission(permission);
        return new ResponseEntity((Object)savedPermission, (HttpStatusCode)HttpStatus.CREATED);
    }

    @GetMapping(value={"/getall"})
    public ResponseEntity<List<Permission>> getAllPermissions() {
        List permissions = this.permissionService.getAllPermissions();
        return new ResponseEntity((Object)permissions, (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<Permission> getPermissionById(@PathVariable Long id) {
        Permission permission = this.permissionService.getPermissionById(id);
        return new ResponseEntity((Object)permission, (HttpStatusCode)HttpStatus.OK);
    }
}

