/*
 * Decompiled with CFR 0.152.
 */
package com.backend.Controller;

import com.backend.Entity.Role;
import com.backend.Service.RoleService;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/role"})
@CrossOrigin(origins={"http://localhost:3000", "http://fusionmastertech.com", "https://fusionmastertech.com", "http://www.fusionmastertech.com", "https://www.fusionmastertech.com"}, allowCredentials="true")
public class RoleController {
    @Autowired
    private RoleService roleService;

    @GetMapping(value={"/check"})
    public ResponseEntity<?> checkRoleName(@RequestParam String name) {
        boolean exists = this.roleService.existsByRole(name);
        return new ResponseEntity(Map.of("exists", exists), (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"/save"})
    public ResponseEntity<?> saveRole(@RequestBody Role role) {
        Role savedRole = this.roleService.saveRole(role);
        return new ResponseEntity((Object)savedRole, (HttpStatusCode)HttpStatus.CREATED);
    }

    @GetMapping(value={"/getall"})
    public ResponseEntity<List<Role>> getAllRoles() {
        List roles = this.roleService.getAllRoles();
        return new ResponseEntity((Object)roles, (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/names"})
    public ResponseEntity<List<Role>> getRolesWithId() {
        List roles = this.roleService.getRolesWithId();
        return new ResponseEntity((Object)roles, (HttpStatusCode)HttpStatus.OK);
    }

    @PutMapping(value={"/update/{id}"})
    public ResponseEntity<Role> updateRole(@PathVariable Long id, @RequestBody Role updatedRole) {
        try {
            Role role = this.roleService.updateRole(id, updatedRole);
            return new ResponseEntity((Object)role, (HttpStatusCode)HttpStatus.OK);
        }
        catch (RuntimeException e) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
    }

    @DeleteMapping(value={"/delete/{id}"})
    public ResponseEntity<Void> deleteRoleById(@PathVariable Long id) {
        try {
            this.roleService.deleteRoleById(id);
            return new ResponseEntity((HttpStatusCode)HttpStatus.NO_CONTENT);
        }
        catch (RuntimeException e) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
    }

    @GetMapping(value={"/details/{id}"})
    public ResponseEntity<Role> getRoleById(@PathVariable Long id) {
        try {
            Role role = this.roleService.getRoleById(id);
            return new ResponseEntity((Object)role, (HttpStatusCode)HttpStatus.OK);
        }
        catch (RuntimeException e) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
    }
}

