/*
 * Decompiled with CFR 0.152.
 */
package com.backend.Controller;

import com.backend.Entity.SaleDIOrder;
import com.backend.Service.SaleDIOrderService;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sale-di-order"})
@CrossOrigin(origins={"http://localhost:3000", "http://fusionmastertech.com", "https://fusionmastertech.com", "http://www.fusionmastertech.com", "https://www.fusionmastertech.com"}, allowCredentials="true")
public class SaleDIOrderController {
    @Autowired
    private SaleDIOrderService saleDIOrderService;

    @PostMapping(value={"/save"})
    public ResponseEntity<SaleDIOrder> createSale(@RequestBody SaleDIOrder saleDIOrder) {
        SaleDIOrder savedOrderSale = this.saleDIOrderService.saveSaleDIOrder(saleDIOrder);
        return new ResponseEntity((Object)savedOrderSale, (HttpStatusCode)HttpStatus.CREATED);
    }

    @GetMapping(value={"/getall"})
    public ResponseEntity<List<SaleDIOrder>> getAllSales() {
        List orders = this.saleDIOrderService.getAllSaleDIOrders();
        return new ResponseEntity((Object)orders, (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/get/{id}"})
    public ResponseEntity<Optional<SaleDIOrder>> getSaleOrderById(@PathVariable Long id) {
        Optional orders = this.saleDIOrderService.getSaleDIOrderById(id);
        return orders.isPresent() ? new ResponseEntity((Object)orders, (HttpStatusCode)HttpStatus.OK) : new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    @PutMapping(value={"/update/{id}"})
    public ResponseEntity<SaleDIOrder> updateSaleSoOrder(@PathVariable Long id, @RequestBody SaleDIOrder saleDIOrder) {
        SaleDIOrder updatedOrder = this.saleDIOrderService.updateSaleDIOrder(id, saleDIOrder);
        if (updatedOrder != null) {
            return ResponseEntity.ok((Object)updatedOrder);
        }
        return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).body(null);
    }

    @DeleteMapping(value={"/delete/{id}"})
    public ResponseEntity<Void> deletePurchaseOrder(@PathVariable Long id) {
        this.saleDIOrderService.deleteSaleDIOrder(id);
        return new ResponseEntity((HttpStatusCode)HttpStatus.NO_CONTENT);
    }

    @GetMapping(value={"/getAllOrderIds"})
    public ResponseEntity<List<String>> getAllOrderIds() {
        List orderIds = this.saleDIOrderService.getAllOrderIds();
        return new ResponseEntity((Object)orderIds, (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/next-reference-number"})
    public ResponseEntity<String> getNextReferenceNumber() {
        String nextRef = this.saleDIOrderService.getNextReferenceNumber();
        return new ResponseEntity((Object)nextRef, (HttpStatusCode)HttpStatus.OK);
    }
}

