/*
 * Decompiled with CFR 0.152.
 */
package com.backend.Controller;

import com.backend.Entity.StockTransaction;
import com.backend.Repository.StockTransactionRepo;
import com.backend.Service.StockTransactionService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/stock-transactions"})
@CrossOrigin(origins={"http://localhost:3000", "http://fusionmastertech.com", "https://fusionmastertech.com", "http://www.fusionmastertech.com", "https://www.fusionmastertech.com"}, allowCredentials="true")
public class StockTransactionController {
    @Autowired
    private StockTransactionService stockTransactionService;
    @Autowired
    private StockTransactionRepo stockTransactionRepo;

    @PostMapping(value={"/add"})
    public ResponseEntity<List<StockTransaction>> addStockTransactions(@RequestBody List<StockTransaction> stockTransactions) {
        try {
            List savedTransactions = this.stockTransactionService.saveStockTransactions(stockTransactions);
            return new ResponseEntity((Object)savedTransactions, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (Exception e) {
            return new ResponseEntity(null, (HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
    }

    @PutMapping(value={"/update/{id}"})
    public ResponseEntity<StockTransaction> updateStockTransaction(@PathVariable Long id, @RequestBody StockTransaction stockTransaction) {
        return this.stockTransactionRepo.findById((Object)id).map(existing -> {
            existing.setQuantity(stockTransaction.getQuantity());
            existing.setDate(stockTransaction.getDate());
            existing.setNote(stockTransaction.getNote());
            existing.setPrice(stockTransaction.getPrice());
            existing.setTransactionType(stockTransaction.getTransactionType());
            return new ResponseEntity((Object)((StockTransaction)this.stockTransactionRepo.save(existing)), (HttpStatusCode)HttpStatus.OK);
        }).orElseGet(() -> new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND));
    }

    @GetMapping(value={"/by-product/{productId}"})
    public ResponseEntity<List<StockTransaction>> getTransactionsByProduct(@PathVariable Long productId) {
        List transactions = this.stockTransactionService.getTransactionsByProduct(productId);
        if (transactions.isEmpty()) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.NO_CONTENT);
        }
        return new ResponseEntity((Object)transactions, (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/by-variation/{variationId}"})
    public ResponseEntity<List<StockTransaction>> getTransactionsByVariation(@PathVariable Long variationId) {
        List transactions = this.stockTransactionService.getTransactionsByVariation(variationId);
        if (transactions.isEmpty()) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.NO_CONTENT);
        }
        return new ResponseEntity((Object)transactions, (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/by-product-variation/{productId}/{variationId}"})
    public ResponseEntity<List<StockTransaction>> getTransactionsByProductAndVariation(@PathVariable Long productId, @PathVariable Long variationId) {
        List transactions = this.stockTransactionService.getTransactionsByProductAndVariation(productId, variationId);
        if (transactions.isEmpty()) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.NO_CONTENT);
        }
        return new ResponseEntity((Object)transactions, (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/current-stock/{productId}/{variationId}"})
    public ResponseEntity<Integer> getCurrentStock(@PathVariable Long productId, @PathVariable Long variationId) {
        int currentStock = this.stockTransactionService.getCurrentStock(productId, variationId);
        return new ResponseEntity((Object)currentStock, (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/current-stock/{productId}"})
    public ResponseEntity<Integer> getCurrentStockByProduct(@PathVariable Long productId) {
        int currentStock = this.stockTransactionService.getCurrentStockByProduct(productId);
        return new ResponseEntity((Object)currentStock, (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/current-stock-byvariation/{variationId}"})
    public ResponseEntity<Integer> getCurrentStockByvariation(@PathVariable Long variationId) {
        int currentStock = this.stockTransactionService.getCurrentStockByvariation(variationId);
        return new ResponseEntity((Object)currentStock, (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/getall"})
    public ResponseEntity<List<StockTransaction>> getAllTransactions() {
        List transactions = this.stockTransactionService.getAllTransactions();
        if (transactions.isEmpty()) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.NO_CONTENT);
        }
        return new ResponseEntity((Object)transactions, (HttpStatusCode)HttpStatus.OK);
    }
}

