/*
 * Decompiled with CFR 0.152.
 */
package com.backend.Controller;

import com.backend.Entity.Target;
import com.backend.Service.TargetService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/target"})
@CrossOrigin(origins={"http://localhost:3000", "http://fusionmastertech.com", "https://fusionmastertech.com", "http://www.fusionmastertech.com", "https://www.fusionmastertech.com"}, allowCredentials="true")
public class TargetController {
    private final TargetService targetService;

    @Autowired
    public TargetController(TargetService targetService) {
        this.targetService = targetService;
    }

    @PostMapping(value={"/add"})
    public ResponseEntity<Target> addTarget(@RequestBody Target target) {
        Target createdTarget = this.targetService.saveTarget(target);
        return new ResponseEntity((Object)createdTarget, (HttpStatusCode)HttpStatus.CREATED);
    }

    @GetMapping(value={"/getall"})
    public ResponseEntity<List<Target>> getAllTargets() {
        List targets = this.targetService.getAllTargets();
        return new ResponseEntity((Object)targets, (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/get/{id}"})
    public ResponseEntity<Target> getTargetById(@PathVariable(value="id") Long id) {
        Target target = this.targetService.getTargetById(id);
        if (target == null) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        return new ResponseEntity((Object)target, (HttpStatusCode)HttpStatus.OK);
    }

    @PutMapping(value={"/update/{id}"})
    public ResponseEntity<Target> updateTarget(@PathVariable(value="id") Long id, @RequestBody Target updatedTarget) {
        Target target = this.targetService.updateTarget(id, updatedTarget);
        if (target == null) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        return new ResponseEntity((Object)target, (HttpStatusCode)HttpStatus.OK);
    }

    @DeleteMapping(value={"/delete/{id}"})
    public ResponseEntity<Void> deleteTarget(@PathVariable(value="id") Long id) {
        boolean isDeleted = this.targetService.deleteTargetById(id);
        if (!isDeleted) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.NO_CONTENT);
    }
}

