/*
 * Decompiled with CFR 0.152.
 */
package com.backend.Controller;

import Exceptions.ResourceNotFoundException;
import com.backend.Entity.Variations;
import com.backend.Service.VariationsService;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/variations"})
@CrossOrigin(origins={"http://localhost:3000", "http://fusionmastertech.com", "https://fusionmastertech.com", "http://www.fusionmastertech.com", "https://www.fusionmastertech.com"}, allowCredentials="true")
public class VariationsController {
    @Autowired
    private VariationsService variationService;

    public VariationsController(VariationsService variationService) {
        this.variationService = variationService;
    }

    @PostMapping(value={"/save"})
    public ResponseEntity<Variations> createVariation(@RequestBody Variations variations) {
        try {
            Variations savedVariations = this.variationService.saveVariations(variations);
            return new ResponseEntity((Object)savedVariations, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (Exception e) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
    }

    @GetMapping(value={"/getall"})
    public ResponseEntity<List<Variations>> getAllVariations() {
        List variationList = this.variationService.getAll();
        return new ResponseEntity((Object)variationList, (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<Variations> getVariationById(@PathVariable(value="id") Long id) {
        Optional variation = this.variationService.getById(id);
        return variation.map(v -> new ResponseEntity(v, (HttpStatusCode)HttpStatus.OK)).orElse(new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND));
    }

    @PutMapping(value={"/update/{id}"})
    public ResponseEntity<Variations> updateVariation(@PathVariable(value="id") Long id, @RequestBody Variations updatedVariation) {
        try {
            Variations updated = this.variationService.updateVariation(id, updatedVariation);
            return new ResponseEntity((Object)updated, (HttpStatusCode)HttpStatus.OK);
        }
        catch (ResourceNotFoundException e) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
    }

    @DeleteMapping(value={"/delete/{id}"})
    public ResponseEntity<Void> deleteVariation(@PathVariable(value="id") Long id) {
        try {
            this.variationService.deleteById(id);
            return new ResponseEntity((HttpStatusCode)HttpStatus.NO_CONTENT);
        }
        catch (ResourceNotFoundException e) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
    }
}

