/*
 * Decompiled with CFR 0.152.
 */
package com.backend.Controller;

import com.backend.Entity.WarrantyClaim;
import com.backend.Service.WarrantyClaimService;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/warranty-claim"})
@CrossOrigin(origins={"http://localhost:3000", "http://fusionmastertech.com", "https://fusionmastertech.com", "http://www.fusionmastertech.com", "https://www.fusionmastertech.com"}, allowCredentials="true")
public class WarrantyClaimController {
    @Autowired
    private WarrantyClaimService warrantyClaimService;

    @PostMapping(value={"/save"})
    public ResponseEntity<WarrantyClaim> saveWarrantyClaim(@RequestBody WarrantyClaim warrantyClaim) {
        try {
            WarrantyClaim savedWarrantyClaim = this.warrantyClaimService.saveWarrantyClaim(warrantyClaim);
            return new ResponseEntity((Object)savedWarrantyClaim, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (Exception e) {
            return new ResponseEntity(null, (HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
    }

    @GetMapping(value={"/getall"})
    public ResponseEntity<List<WarrantyClaim>> getAllWarrantyClaims() {
        try {
            List warrantyClaims = this.warrantyClaimService.getAllWarrantyClaims();
            if (warrantyClaims.isEmpty()) {
                return new ResponseEntity((HttpStatusCode)HttpStatus.NO_CONTENT);
            }
            return new ResponseEntity((Object)warrantyClaims, (HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception e) {
            return new ResponseEntity(null, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @GetMapping(value={"/get/{id}"})
    public ResponseEntity<WarrantyClaim> getWarrantyClaimById(@PathVariable(value="id") Long id) {
        Optional warrantyClaim = this.warrantyClaimService.getWarrantyClaimById(id);
        return warrantyClaim.map(claim -> new ResponseEntity(claim, (HttpStatusCode)HttpStatus.OK)).orElseGet(() -> new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND));
    }

    @PutMapping(value={"/update/{id}"})
    public ResponseEntity<WarrantyClaim> updateWarrantyClaim(@PathVariable(value="id") Long id, @RequestBody WarrantyClaim warrantyClaim) {
        try {
            WarrantyClaim updatedWarrantyClaim = this.warrantyClaimService.updateWarrantyClaim(id, warrantyClaim);
            return new ResponseEntity((Object)updatedWarrantyClaim, (HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception e) {
            return new ResponseEntity(null, (HttpStatusCode)HttpStatus.NOT_FOUND);
        }
    }

    @DeleteMapping(value={"/delete/{id}"})
    public ResponseEntity<HttpStatus> deleteWarrantyClaim(@PathVariable(value="id") Long id) {
        try {
            this.warrantyClaimService.deleteWarrantyClaim(id);
            return new ResponseEntity((HttpStatusCode)HttpStatus.NO_CONTENT);
        }
        catch (Exception e) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
    }

    @PutMapping(value={"/updateStatus/{id}"})
    public ResponseEntity<WarrantyClaim> updateWarrantyClaimStatus(@PathVariable(value="id") Long id, @RequestBody Long newStatus) {
        try {
            WarrantyClaim updatedWarrantyClaim = this.warrantyClaimService.updateWarrantyClaimStatus(id, newStatus);
            return new ResponseEntity((Object)updatedWarrantyClaim, (HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception e) {
            return new ResponseEntity(null, (HttpStatusCode)HttpStatus.NOT_FOUND);
        }
    }
}

