/*
 * Decompiled with CFR 0.152.
 */
package com.backend.Entity;

import com.backend.Entity.PurchaseReturnItems;
import com.backend.Entity.StockTransaction;
import com.backend.Service.IdGenerator;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.OneToMany;
import jakarta.persistence.PrePersist;
import jakarta.persistence.Transient;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.List;

@Entity
public class PurchaseReturn {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    private String purchaseReturnId;
    private Long status;
    private String vendor;
    private String addedBy;
    private Long paymentStatus;
    private String referenceNumber;
    private String invoiceNumber;
    private Date orderDate;
    private String receipt;
    private Long totalItems;
    private Long purchaseTax;
    private BigDecimal totalAmount;
    private Long totalShippedItems;
    private String additionalNotes;
    @OneToMany(mappedBy="purchaseReturn", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<PurchaseReturnItems> purchaseReturnItems;
    @OneToMany(mappedBy="purchaseReturn", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<StockTransaction> stockTransactions;
    @Transient
    private IdGenerator idGenerator;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getPurchaseReturnId() {
        return this.purchaseReturnId;
    }

    public void setPurchaseReturnId(String purchaseReturnId) {
        this.purchaseReturnId = purchaseReturnId;
    }

    public Long getStatus() {
        return this.status;
    }

    public void setStatus(Long status) {
        this.status = status;
    }

    public String getVendor() {
        return this.vendor;
    }

    public void setVendor(String vendor) {
        this.vendor = vendor;
    }

    public String getAddedBy() {
        return this.addedBy;
    }

    public void setAddedBy(String addedBy) {
        this.addedBy = addedBy;
    }

    public Long getPaymentStatus() {
        return this.paymentStatus;
    }

    public void setPaymentStatus(Long paymentStatus) {
        this.paymentStatus = paymentStatus;
    }

    public String getReferenceNumber() {
        return this.referenceNumber;
    }

    public void setReferenceNumber(String referenceNumber) {
        this.referenceNumber = referenceNumber;
    }

    public String getInvoiceNumber() {
        return this.invoiceNumber;
    }

    public void setInvoiceNumber(String invoiceNumber) {
        this.invoiceNumber = invoiceNumber;
    }

    public Date getOrderDate() {
        return this.orderDate;
    }

    public void setOrderDate(Date orderDate) {
        this.orderDate = orderDate;
    }

    public String getReceipt() {
        return this.receipt;
    }

    public void setReceipt(String receipt) {
        this.receipt = receipt;
    }

    public BigDecimal getTotalAmount() {
        return this.totalAmount;
    }

    public void setTotalAmount(BigDecimal totalAmount) {
        this.totalAmount = totalAmount;
    }

    public Long getTotalItems() {
        return this.totalItems;
    }

    public void setTotalItems(Long totalItems) {
        this.totalItems = totalItems;
    }

    public Long getPurchaseTax() {
        return this.purchaseTax;
    }

    public void setPurchaseTax(Long purchaseTax) {
        this.purchaseTax = purchaseTax;
    }

    public Long getTotalShippedItems() {
        return this.totalShippedItems;
    }

    public void setTotalShippedItems(Long totalShippedItems) {
        this.totalShippedItems = totalShippedItems;
    }

    public String getAdditionalNotes() {
        return this.additionalNotes;
    }

    public void setAdditionalNotes(String additionalNotes) {
        this.additionalNotes = additionalNotes;
    }

    public List<PurchaseReturnItems> getPurchaseReturnItems() {
        return this.purchaseReturnItems;
    }

    public void setPurchaseReturnItems(List<PurchaseReturnItems> purchaseReturnItems) {
        this.purchaseReturnItems = purchaseReturnItems;
    }

    public IdGenerator getIdGenerator() {
        return this.idGenerator;
    }

    public void setIdGenerator(IdGenerator idGenerator) {
        this.idGenerator = idGenerator;
    }

    @PrePersist
    private void generateIds() {
        if (this.purchaseReturnId == null && this.idGenerator != null) {
            this.purchaseReturnId = this.idGenerator.generatePurchaseReturnId();
        }
        if (this.invoiceNumber == null && this.idGenerator != null) {
            this.invoiceNumber = this.idGenerator.generatePurchaseReturnInvoiceNumber();
        }
    }

    public List<StockTransaction> getStockTransactions() {
        return this.stockTransactions;
    }

    public void setStockTransactions(List<StockTransaction> stockTransactions) {
        this.stockTransactions = stockTransactions;
    }
}

