/*
 * Decompiled with CFR 0.152.
 */
package com.backend.Entity;

import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToMany;
import java.util.List;

@Entity
public class Tax {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    private String taxName;
    private Double taxValue;
    @ManyToMany
    @JoinTable(name="group_tax_mapping", joinColumns={@JoinColumn(name="group_tax_id")}, inverseJoinColumns={@JoinColumn(name="single_tax_id")})
    private List<Tax> includedTaxes;

    public Double calculateTotalTax() {
        if (this.includedTaxes == null || this.includedTaxes.isEmpty()) {
            return this.taxValue != null ? this.taxValue : 0.0;
        }
        return this.includedTaxes.stream().mapToDouble(tax -> tax.getTaxValue() != null ? tax.getTaxValue() : 0.0).sum();
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getTaxName() {
        return this.taxName;
    }

    public void setTaxName(String taxName) {
        this.taxName = taxName;
    }

    public Double getTaxValue() {
        return this.calculateTotalTax();
    }

    public void setTaxValue(Double taxValue) {
        this.taxValue = taxValue;
    }

    public List<Tax> getIncludedTaxes() {
        return this.includedTaxes;
    }

    public void setIncludedTaxes(List<Tax> includedTaxes) {
        this.includedTaxes = includedTaxes;
    }
}

