/*
 * Decompiled with CFR 0.152.
 */
package com.backend.Service;

import com.backend.Repository.FranchisePurchaseOrderRepo;
import com.backend.Repository.FranchisePurchaseReturnRepo;
import com.backend.Repository.PurchaseDIOrderRepo;
import com.backend.Repository.PurchaseOrderRepo;
import com.backend.Repository.PurchaseReturnRepo;
import com.backend.Repository.SaleDIOrderRepo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class IdGenerator {
    @Autowired
    private PurchaseOrderRepo purchaseOrderRepo;
    @Autowired
    private PurchaseDIOrderRepo purchaseDIOrderRepo;
    @Autowired
    private SaleDIOrderRepo saleDIOrderRepo;
    @Autowired
    private PurchaseReturnRepo PurchaseReturnRepo;
    @Autowired
    private FranchisePurchaseOrderRepo franchisePurchaseOrderRepo;
    @Autowired
    private FranchisePurchaseReturnRepo franchisePurchaseReturnRepo;

    public synchronized String generatePurchaseOrderId() {
        Long lastId = this.purchaseOrderRepo.getLastPurchaseOrderId();
        Long nextId = lastId != null ? lastId + 1L : 1L;
        return "FUMAPO" + nextId;
    }

    public synchronized String generatePurchaseDIOrderId() {
        Long lastId = this.purchaseDIOrderRepo.getLastPurchaseDIOrderId();
        Long nextId = lastId != null ? lastId + 1L : 1L;
        return "FUMAPDI" + nextId;
    }

    public synchronized String generateSaleDIOrderId() {
        Long lastId = this.saleDIOrderRepo.getLastSaleDIOrderId();
        Long nextId = lastId != null ? lastId + 1L : 1L;
        return "FUMADISO" + nextId;
    }

    public synchronized String generatePurchaseReturnId() {
        Long lastId = this.PurchaseReturnRepo.getLastPurchaseReturnId();
        Long nextId = lastId != null ? lastId + 1L : 1L;
        return "FUMAPR" + nextId;
    }

    public synchronized String generateFranchisePurchaseOrderId() {
        Long lastId = this.franchisePurchaseOrderRepo.getLastFranchisePurchaseOrderId();
        Long nextId = lastId != null ? lastId + 1L : 1L;
        return "FUMAFPO" + nextId;
    }

    public synchronized String generateFranchisePurchaseReturnId() {
        Long lastId = this.franchisePurchaseReturnRepo.getLastFranchisePurchaseReturnId();
        Long nextId = lastId != null ? lastId + 1L : 1L;
        return "FUMAFPRO" + nextId;
    }

    public synchronized String generatePurchaseReturnInvoiceNumber() {
        String lastInvoice = this.PurchaseReturnRepo.getLastInvoiceNumber();
        if (lastInvoice != null && lastInvoice.startsWith("PRInvoice")) {
            String numberPart = lastInvoice.replace("PRInvoice", "");
            int nextNumber = Integer.parseInt(numberPart) + 1;
            return String.format("PRInvoice%02d", nextNumber);
        }
        return "PRInvoice01";
    }

    public synchronized String generateFranchisePurchaseReturnInvoiceNumber() {
        String lastInvoice = this.franchisePurchaseReturnRepo.getLastInvoiceNumber();
        if (lastInvoice != null && lastInvoice.startsWith("FRPRInvoice")) {
            String numberPart = lastInvoice.replace("FRPRInvoice", "");
            int nextNumber = Integer.parseInt(numberPart) + 1;
            return String.format("FRPRInvoice%03d", nextNumber);
        }
        return "FRPRInvoice01";
    }
}

