/*
 * Decompiled with CFR 0.152.
 */
package com.backend.ServiceImpl;

import com.backend.Entity.Department;
import com.backend.Repository.DepartmentRepo;
import com.backend.Service.DepartmentService;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DepartmentServiceImpl
implements DepartmentService {
    @Autowired
    private DepartmentRepo departmentRepo;

    public Department saveDepartment(Department department) {
        if (this.departmentRepo.existsByDepartmentId(department.getDepartmentId())) {
            throw new IllegalArgumentException("Department ID " + department.getDepartmentId() + " already exists.");
        }
        return (Department)this.departmentRepo.save((Object)department);
    }

    public List<Department> getAllDepartments() {
        return this.departmentRepo.findAll();
    }

    public Department updateDepartment(Long id, Department department) {
        Optional existingDepartment = this.departmentRepo.findById((Object)id);
        if (!existingDepartment.isPresent()) {
            throw new IllegalArgumentException("Department with ID " + id + " does not exist.");
        }
        if (!((Department)existingDepartment.get()).getDepartmentId().equals(department.getDepartmentId()) && this.departmentRepo.existsByDepartmentId(department.getDepartmentId())) {
            throw new IllegalArgumentException("Department ID " + department.getDepartmentId() + " already exists.");
        }
        department.setId(id);
        return (Department)this.departmentRepo.save((Object)department);
    }

    public Department getDepartmentById(Long id) {
        return (Department)this.departmentRepo.findById((Object)id).orElseThrow(() -> new IllegalArgumentException("Department with ID " + id + " not found"));
    }

    public void deleteDepartmentById(Long id) {
        this.departmentRepo.deleteById((Object)id);
    }
}

