/*
 * Decompiled with CFR 0.152.
 */
package com.backend.ServiceImpl;

import com.backend.Entity.FranchiseWarrantyClaim;
import com.backend.Repository.FranchiseWarrantyClaimRepo;
import com.backend.Service.FranchiseWarrantyClaimService;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FranchiseWarrantyClaimServiceImpl
implements FranchiseWarrantyClaimService {
    @Autowired
    private FranchiseWarrantyClaimRepo franchiseWarrantyClaimRepo;

    public FranchiseWarrantyClaim saveWarrantyClaim(FranchiseWarrantyClaim franchiseWarrantyClaim) {
        if (franchiseWarrantyClaim.getFranchiseWarrantyClaimItems() != null) {
            franchiseWarrantyClaim.getFranchiseWarrantyClaimItems().forEach(item -> item.setFranchiseWarrantyClaim(franchiseWarrantyClaim));
        }
        return (FranchiseWarrantyClaim)this.franchiseWarrantyClaimRepo.save((Object)franchiseWarrantyClaim);
    }

    public List<FranchiseWarrantyClaim> getAllWarrantyClaims() {
        return this.franchiseWarrantyClaimRepo.findAll();
    }

    public Optional<FranchiseWarrantyClaim> getWarrantyClaimById(Long id) {
        return this.franchiseWarrantyClaimRepo.findById((Object)id);
    }

    public FranchiseWarrantyClaim updateWarrantyClaim(Long id, FranchiseWarrantyClaim franchiseWarrantyClaim) {
        Optional existingClaim = this.franchiseWarrantyClaimRepo.findById((Object)id);
        if (existingClaim.isPresent()) {
            FranchiseWarrantyClaim updatedClaim = (FranchiseWarrantyClaim)existingClaim.get();
            updatedClaim.setVendor(franchiseWarrantyClaim.getVendor());
            updatedClaim.setFranchise(franchiseWarrantyClaim.getFranchise());
            updatedClaim.setReferenceNumber(franchiseWarrantyClaim.getReferenceNumber());
            updatedClaim.setDate(franchiseWarrantyClaim.getDate());
            updatedClaim.setStatus(franchiseWarrantyClaim.getStatus());
            updatedClaim.setTotalAmount(franchiseWarrantyClaim.getTotalAmount());
            updatedClaim.setUpdatedTotalAmount(franchiseWarrantyClaim.getUpdatedTotalAmount());
            updatedClaim.setTotalUnits(franchiseWarrantyClaim.getTotalUnits());
            updatedClaim.setUpdatedTotalUnits(franchiseWarrantyClaim.getUpdatedTotalUnits());
            updatedClaim.setReason(franchiseWarrantyClaim.getReason());
            if (franchiseWarrantyClaim.getFranchiseWarrantyClaimItems() != null) {
                franchiseWarrantyClaim.getFranchiseWarrantyClaimItems().forEach(item -> item.setFranchiseWarrantyClaim(updatedClaim));
                updatedClaim.setFranchiseWarrantyClaimItems(franchiseWarrantyClaim.getFranchiseWarrantyClaimItems());
            }
            if (franchiseWarrantyClaim.getStockTransaction() != null) {
                franchiseWarrantyClaim.getStockTransaction().forEach(tx -> tx.setFranchiseWarrantyClaim(updatedClaim));
                updatedClaim.setStockTransaction(franchiseWarrantyClaim.getStockTransaction());
            }
            return (FranchiseWarrantyClaim)this.franchiseWarrantyClaimRepo.save((Object)updatedClaim);
        }
        throw new RuntimeException("Franchise Warranty Claim not found with ID: " + id);
    }

    public void deleteWarrantyClaim(Long id) {
        if (!this.franchiseWarrantyClaimRepo.existsById((Object)id)) {
            throw new RuntimeException("Franchise Warranty Claim not found with ID: " + id);
        }
        this.franchiseWarrantyClaimRepo.deleteById((Object)id);
    }

    public FranchiseWarrantyClaim updateWarrantyClaimStatus(Long id, Long newStatus) {
        Optional existingClaim = this.franchiseWarrantyClaimRepo.findById((Object)id);
        if (existingClaim.isPresent()) {
            FranchiseWarrantyClaim claim = (FranchiseWarrantyClaim)existingClaim.get();
            claim.setStatus(newStatus);
            return (FranchiseWarrantyClaim)this.franchiseWarrantyClaimRepo.save((Object)claim);
        }
        throw new RuntimeException("Franchise Warranty Claim not found with ID: " + id);
    }

    public List<FranchiseWarrantyClaim> getPendingOrders() {
        return this.franchiseWarrantyClaimRepo.findByStatus(Long.valueOf(0L));
    }

    public List<FranchiseWarrantyClaim> getAcceptedOrders() {
        return this.franchiseWarrantyClaimRepo.findByStatus(Long.valueOf(1L));
    }

    public List<FranchiseWarrantyClaim> getRejectedOrders() {
        return this.franchiseWarrantyClaimRepo.findByStatus(Long.valueOf(2L));
    }

    public List<FranchiseWarrantyClaim> getShipOrders() {
        return this.franchiseWarrantyClaimRepo.findByStatus(Long.valueOf(3L));
    }
}

