/*
 * Decompiled with CFR 0.152.
 */
package com.backend.ServiceImpl;

import com.backend.Entity.Product;
import com.backend.Entity.ProductVariations;
import com.backend.Repository.ProductRepo;
import com.backend.Repository.ProductVariationsRepo;
import com.backend.Service.ProductService;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ProductServiceImpl
implements ProductService {
    @Autowired
    private ProductRepo productRepository;
    @Autowired
    private ProductVariationsRepo productVariationRepo;

    public Product getProductById(Long id) {
        Optional product = this.productRepository.findById((Object)id);
        return product.orElse(null);
    }

    public List<Product> getAllProducts() {
        return this.productRepository.findAll();
    }

    public Product updateProduct(Long id, Product product) {
        if (this.productRepository.existsById((Object)id)) {
            product.setId(id);
            if (product.getProductVariations() != null) {
                for (ProductVariations variation : product.getProductVariations()) {
                    if (variation.getId() != null) {
                        ProductVariations existingVariation = product.getProductVariations().stream().filter(v -> v.getId().equals(variation.getId())).findFirst().orElse(null);
                        if (existingVariation == null) continue;
                        variation.setProduct(product);
                        variation.setVariationProductImages(existingVariation.getVariationProductImages());
                        continue;
                    }
                    variation.setId(null);
                }
            }
            return (Product)this.productRepository.save((Object)product);
        }
        return null;
    }

    public void deleteProduct(Long id) {
        this.productRepository.deleteById((Object)id);
    }

    public List<Product> searchProducts(String query) {
        return this.productRepository.searchProducts(query);
    }

    public Optional<Product> findProductDetailsByIdAndVariation(Long productId, Long productVariationId) {
        return this.productVariationRepo.findProductDetailsByIdAndVariation(productId, productVariationId).map(ProductVariations::getProduct);
    }

    public Product saveProduct(Product product) {
        if (this.isSkuExists(product.getSku())) {
            throw new IllegalArgumentException("SKU already exists: " + product.getSku());
        }
        if (product.getSku() == null || product.getSku().isEmpty()) {
            product.setSku(this.generateNextSku());
        }
        if (product.getProductVariations() != null) {
            for (ProductVariations variation : product.getProductVariations()) {
                variation.setProduct(product);
                if (product.getProductType() != Product.ProductType.COMBO) continue;
                variation.setComboVariations(variation.getComboVariations());
            }
        }
        return (Product)this.productRepository.save((Object)product);
    }

    public boolean isSkuExists(String sku) {
        return this.productRepository.findBySku(sku).isPresent();
    }

    public String generateNextSku() {
        Optional lastProduct = this.productRepository.findTopByOrderByIdDesc();
        if (lastProduct.isPresent()) {
            Product last = (Product)lastProduct.get();
            String lastSku = last.getSku();
            if (lastSku == null || lastSku.isEmpty()) {
                return "1000";
            }
            String numericPart = lastSku.replaceAll("[^0-9]", "");
            if (numericPart.isEmpty()) {
                return "1000";
            }
            try {
                long nextSkuNumber = Long.parseLong(numericPart) + 1L;
                String prefix = lastSku.replaceAll("[0-9]", "");
                return prefix + nextSkuNumber;
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Invalid SKU format, unable to parse numeric part: " + lastSku, e);
            }
        }
        return "1000";
    }

    public boolean isSkuUnique(String sku) {
        return !this.productRepository.existsBySku(sku);
    }

    public List<Product> getProductsByStatus(Long status) {
        return this.productRepository.findByStatus(status);
    }

    public Product updateProductStatus(Product product) {
        return (Product)this.productRepository.save((Object)product);
    }

    public List<Product> searchActiveProducts(String query) {
        return this.productRepository.searchActive(query);
    }

    public List<Product> searchInactiveProducts(String query) {
        return this.productRepository.searchInactive(query);
    }
}

