/*
 * Decompiled with CFR 0.152.
 */
package com.backend.ServiceImpl;

import com.backend.Entity.Permission;
import com.backend.Entity.Role;
import com.backend.Repository.PermissionRepo;
import com.backend.Repository.RoleRepository;
import com.backend.Service.RoleService;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RoleServiceImpl
implements RoleService {
    @Autowired
    private RoleRepository roleRepository;
    @Autowired
    private PermissionRepo permissionRepository;

    public Role saveRole(Role role) {
        return (Role)this.roleRepository.save((Object)role);
    }

    public List<Role> getAllRoles() {
        return this.roleRepository.findAll();
    }

    public Role updateRole(Long roleId, Role updatedRole) {
        return this.roleRepository.findById(roleId).map(role -> {
            role.setRole(updatedRole.getRole());
            Set permissionIds = updatedRole.getPermissions().stream().map(Permission::getId).collect(Collectors.toSet());
            HashSet permissions = new HashSet(this.permissionRepository.findAllById(permissionIds));
            role.setPermissions(permissions);
            return (Role)this.roleRepository.save(role);
        }).orElseThrow(() -> new RuntimeException("Role not found with id " + roleId));
    }

    public Role getRoleById(Long id) {
        return (Role)this.roleRepository.findById(id).orElseThrow(() -> new RuntimeException("Role not found with id " + id));
    }

    public List<Role> getRolesWithId() {
        return this.roleRepository.findAll();
    }

    public void deleteRoleById(Long id) {
        this.roleRepository.findById(id).map(role -> {
            this.roleRepository.delete(role);
            return role;
        }).orElseThrow(() -> new RuntimeException("Role not found with id " + id));
    }

    public boolean existsByRole(String roleName) {
        return this.roleRepository.existsByRole(roleName);
    }
}

