/*
 * Decompiled with CFR 0.152.
 */
package com.backend.ServiceImpl;

import com.backend.Entity.SaleDIItem;
import com.backend.Entity.SaleDIOrder;
import com.backend.Entity.ShippingSaleDIDetails;
import com.backend.Entity.StockTransaction;
import com.backend.Repository.SaleDIOrderRepo;
import com.backend.Service.IdGenerator;
import com.backend.Service.SaleDIOrderService;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class SaleDIOrderServiceImpl
implements SaleDIOrderService {
    @Autowired
    private SaleDIOrderRepo saleDIOrderRepo;
    @Autowired
    private IdGenerator idGenerator;

    public SaleDIOrder saveSaleDIOrder(SaleDIOrder saleDIOrder) {
        saleDIOrder.setIdGenerator(this.idGenerator);
        if (saleDIOrder.getSaleDIItem() != null) {
            for (SaleDIItem item : saleDIOrder.getSaleDIItem()) {
                item.setSaleDIOrder(saleDIOrder);
            }
        }
        if (saleDIOrder.getShippingSaleDIDetails() != null) {
            for (ShippingSaleDIDetails ship : saleDIOrder.getShippingSaleDIDetails()) {
                ship.setSaleDIOrder(saleDIOrder);
            }
        }
        if (saleDIOrder.getStockTransactions() != null) {
            for (StockTransaction stock : saleDIOrder.getStockTransactions()) {
                stock.setSaleDIOrder(saleDIOrder);
            }
        }
        return (SaleDIOrder)this.saleDIOrderRepo.save((Object)saleDIOrder);
    }

    public List<SaleDIOrder> getAllSaleDIOrders() {
        return this.saleDIOrderRepo.findAll();
    }

    public Optional<SaleDIOrder> getSaleDIOrderById(Long id) {
        return this.saleDIOrderRepo.findById((Object)id);
    }

    public void deleteSaleDIOrder(Long id) {
        if (this.saleDIOrderRepo.existsById((Object)id)) {
            this.saleDIOrderRepo.deleteById((Object)id);
        }
    }

    public List<String> getAllOrderIds() {
        return null;
    }

    public SaleDIOrder updateSaleDIOrder(Long id, SaleDIOrder saleDIOrder) {
        Optional existingOrderOpt = this.saleDIOrderRepo.findById((Object)id);
        if (existingOrderOpt.isPresent()) {
            SaleDIOrder existingOrder = (SaleDIOrder)existingOrderOpt.get();
            existingOrder.setSaleDIOrderId(saleDIOrder.getSaleDIOrderId());
            existingOrder.setFranchise(saleDIOrder.getFranchise());
            existingOrder.setReferenceNumber(saleDIOrder.getReferenceNumber());
            existingOrder.setAddedBy(saleDIOrder.getAddedBy());
            existingOrder.setSaleDate(saleDIOrder.getSaleDate());
            existingOrder.setCustomerId(saleDIOrder.getCustomerId());
            existingOrder.setPayTermNumber(saleDIOrder.getPayTermNumber());
            existingOrder.setPayTermType(saleDIOrder.getPayTermType());
            existingOrder.setLocation(saleDIOrder.getLocation());
            existingOrder.setTotalItems(saleDIOrder.getTotalItems());
            existingOrder.setNetTotalAmount(saleDIOrder.getNetTotalAmount());
            existingOrder.setDiscountType(saleDIOrder.getDiscountType());
            existingOrder.setDiscountAmount(saleDIOrder.getDiscountAmount());
            existingOrder.setPurchaseTax(saleDIOrder.getPurchaseTax());
            existingOrder.setTaxAmount(saleDIOrder.getTaxAmount());
            existingOrder.setAdditionalNotes(saleDIOrder.getAdditionalNotes());
            existingOrder.getSaleDIItem().clear();
            if (saleDIOrder.getSaleDIItem() != null) {
                for (SaleDIItem item : saleDIOrder.getSaleDIItem()) {
                    item.setSaleDIOrder(existingOrder);
                }
                existingOrder.getSaleDIItem().addAll(saleDIOrder.getSaleDIItem());
            }
            existingOrder.getShippingSaleDIDetails().clear();
            if (saleDIOrder.getShippingSaleDIDetails() != null) {
                for (ShippingSaleDIDetails shipping : saleDIOrder.getShippingSaleDIDetails()) {
                    shipping.setSaleDIOrder(existingOrder);
                }
                existingOrder.getShippingSaleDIDetails().addAll(saleDIOrder.getShippingSaleDIDetails());
            }
            existingOrder.getStockTransactions().clear();
            if (saleDIOrder.getStockTransactions() != null) {
                for (StockTransaction stock : saleDIOrder.getStockTransactions()) {
                    stock.setSaleDIOrder(existingOrder);
                }
                existingOrder.getStockTransactions().addAll(saleDIOrder.getStockTransactions());
            }
            return (SaleDIOrder)this.saleDIOrderRepo.save((Object)existingOrder);
        }
        return null;
    }

    public String getNextReferenceNumber() {
        List results = this.saleDIOrderRepo.findTopOrderByReferenceNumber((Pageable)PageRequest.of((int)0, (int)1));
        if (!results.isEmpty()) {
            String lastRef = ((SaleDIOrder)results.get(0)).getReferenceNumber();
            try {
                String numberPart = lastRef.replaceAll("\\D+", "");
                int nextNumber = Integer.parseInt(numberPart) + 1;
                return "FUMADIS" + nextNumber;
            }
            catch (NumberFormatException e) {
                return "FUMADIS1";
            }
        }
        return "FUMADIS1";
    }
}

