/*
 * Decompiled with CFR 0.152.
 */
package com.backend.ServiceImpl;

import com.backend.Entity.SaleReturn;
import com.backend.Entity.SaleReturnItems;
import com.backend.Entity.StockTransaction;
import com.backend.Repository.SaleReturnRepo;
import com.backend.Service.SaleReturnService;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SaleReturnServiceImpl
implements SaleReturnService {
    @Autowired
    private SaleReturnRepo saleReturnRepo;

    public SaleReturn saveSaleReturn(SaleReturn saleReturn) {
        if (saleReturn.getSaleReturnItems() != null) {
            for (SaleReturnItems item : saleReturn.getSaleReturnItems()) {
                item.setSaleReturn(saleReturn);
            }
        }
        if (saleReturn.getStockTransactions() != null) {
            for (StockTransaction stock : saleReturn.getStockTransactions()) {
                stock.setSaleReturn(saleReturn);
            }
        }
        return (SaleReturn)this.saleReturnRepo.save((Object)saleReturn);
    }

    public List<SaleReturn> getAllSaleReturns() {
        return this.saleReturnRepo.findAll();
    }

    public Optional<SaleReturn> getSaleReturnById(Long id) {
        return this.saleReturnRepo.findById((Object)id);
    }

    public SaleReturn updateSaleReturn(Long id, SaleReturn updatedSaleReturn) {
        Optional existingSaleReturn = this.saleReturnRepo.findById((Object)id);
        if (existingSaleReturn.isPresent()) {
            SaleReturn saleReturn = (SaleReturn)existingSaleReturn.get();
            saleReturn.setVendor(updatedSaleReturn.getVendor());
            saleReturn.setStatus(updatedSaleReturn.getStatus());
            saleReturn.setAddedBy(updatedSaleReturn.getAddedBy());
            saleReturn.setReferenceNumber(updatedSaleReturn.getReferenceNumber());
            saleReturn.setOrderDate(updatedSaleReturn.getOrderDate());
            saleReturn.setLocation(updatedSaleReturn.getLocation());
            saleReturn.setTotalItems(updatedSaleReturn.getTotalItems());
            saleReturn.setTotalShippedItems(updatedSaleReturn.getTotalShippedItems());
            saleReturn.setAdditionalNotes(updatedSaleReturn.getAdditionalNotes());
            saleReturn.getSaleReturnItems().clear();
            saleReturn.getSaleReturnItems().addAll(updatedSaleReturn.getSaleReturnItems());
            for (SaleReturnItems item : saleReturn.getSaleReturnItems()) {
                item.setSaleReturn(saleReturn);
            }
            saleReturn.getStockTransactions().clear();
            saleReturn.getStockTransactions().addAll(updatedSaleReturn.getStockTransactions());
            for (StockTransaction stock : saleReturn.getStockTransactions()) {
                stock.setSaleReturn(saleReturn);
            }
            return (SaleReturn)this.saleReturnRepo.save((Object)saleReturn);
        }
        return null;
    }

    public void deleteSaleReturn(Long id) {
        if (this.saleReturnRepo.existsById((Object)id)) {
            this.saleReturnRepo.deleteById((Object)id);
        }
    }

    public List<String> getAllReturnIds() {
        return this.saleReturnRepo.findAll().stream().map(SaleReturn::getPurchaseReturnId).collect(Collectors.toList());
    }

    public Optional<SaleReturn> getSaleReturnByPRId(String purchaseReturnId) {
        return Optional.ofNullable(this.saleReturnRepo.findByPurchaseReturnId(purchaseReturnId));
    }

    public List<String> getSaleReturnIdsByStatus(Long status) {
        return this.saleReturnRepo.findSaleReturnIdsByStatus(status);
    }

    public List<SaleReturn> getPendingOrders() {
        return this.saleReturnRepo.findBySaleReturnStatus(Long.valueOf(0L));
    }

    public List<SaleReturn> getAcceptedOrders() {
        return this.saleReturnRepo.findBySaleReturnStatus(Long.valueOf(1L));
    }

    public List<SaleReturn> getRejectedOrders() {
        return this.saleReturnRepo.findBySaleReturnStatus(Long.valueOf(2L));
    }

    public List<SaleReturn> getShipOrders() {
        return this.saleReturnRepo.findBySaleReturnStatus(Long.valueOf(3L));
    }

    public Long getTotalShippedItems(String purchaseReturnId) {
        return this.saleReturnRepo.getTotalShippedItems(purchaseReturnId);
    }
}

