/*
 * Decompiled with CFR 0.152.
 */
package com.backend.ServiceImpl;

import com.backend.Entity.JournalEntry;
import com.backend.Entity.PurchaseDIOrder;
import com.backend.Entity.PurchasePoOrder;
import com.backend.Entity.SaleDIOrder;
import com.backend.Entity.SaleSoOrder;
import com.backend.Entity.Transaction;
import com.backend.Repository.CustomerRepo;
import com.backend.Repository.PurchaseDIOrderRepo;
import com.backend.Repository.PurchasePoOrderRepo;
import com.backend.Repository.SaleDIOrderRepo;
import com.backend.Repository.SaleSoOrderRepo;
import com.backend.Repository.TransactionRepo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TrailBalanceService {
    @Autowired
    private PurchasePoOrderRepo poRepo;
    @Autowired
    private PurchaseDIOrderRepo diPurchaseRepo;
    @Autowired
    private SaleSoOrderRepo soRepo;
    @Autowired
    private SaleDIOrderRepo diSaleRepo;
    @Autowired
    private TransactionRepo txnRepo;
    @Autowired
    private CustomerRepo customerRepo;
    private Map<String, JournalEntry> ledger;

    private void addDebit(String account, BigDecimal amount) {
        this.ledger.putIfAbsent(account, new JournalEntry(account));
        ((JournalEntry)this.ledger.get(account)).addDebit(amount);
    }

    private void addCredit(String account, BigDecimal amount) {
        this.ledger.putIfAbsent(account, new JournalEntry(account));
        ((JournalEntry)this.ledger.get(account)).addCredit(amount);
    }

    private void handlePurchases() {
        List list = this.poRepo.findAll();
        for (PurchasePoOrder p : list) {
            BigDecimal amount = p.getNetTotalAmount();
            if (amount == null) continue;
            String supplier = "Supplier - " + p.getVendor();
            this.addDebit("Purchase Account", amount);
            this.addCredit(supplier, amount);
        }
    }

    private void handlePurchaseDI() {
        List list = this.diPurchaseRepo.findAll();
        for (PurchaseDIOrder p : list) {
            BigDecimal amount = p.getNetTotalAmount();
            if (amount == null) continue;
            String supplier = "Supplier - " + p.getVendor();
            this.addDebit("Purchase Account", amount);
            this.addCredit(supplier, amount);
        }
    }

    private void handleSalesSO() {
        List list = this.soRepo.findAll();
        for (SaleSoOrder s : list) {
            BigDecimal amount = s.getNetTotalAmount();
            if (amount == null) continue;
            String customer = "Customer - " + s.getCustomerId();
            this.addDebit(customer, amount);
            this.addCredit("Sales Account", amount);
        }
    }

    private void handleSalesDI() {
        List list = this.diSaleRepo.findAll();
        for (SaleDIOrder s : list) {
            BigDecimal amount = s.getNetTotalAmount();
            if (amount == null) continue;
            String customer = "Customer - " + s.getCustomerId();
            this.addDebit(customer, amount);
            this.addCredit("Sales Account", amount);
        }
    }

    private void handleTransactions() {
        List list = this.txnRepo.findAll();
        for (Transaction t : list) {
            if (t.getPaymentAccount() == null) continue;
            String accountName = t.getPaymentAccount().getAccountName();
            BigDecimal debit = t.getDebit();
            BigDecimal credit = t.getCredit();
            if (debit.compareTo(BigDecimal.ZERO) > 0) {
                this.addDebit(accountName, debit);
            }
            if (credit.compareTo(BigDecimal.ZERO) <= 0) continue;
            this.addCredit(accountName, credit);
        }
    }

    public List<JournalEntry> generateTrailBalance() {
        this.ledger = new LinkedHashMap();
        this.handlePurchases();
        this.handlePurchaseDI();
        this.handleSalesSO();
        this.handleSalesDI();
        this.handleTransactions();
        return new ArrayList<JournalEntry>(this.ledger.values());
    }
}

