/*
 * Decompiled with CFR 0.152.
 */
package com.backend.ServiceImpl;

import com.backend.Entity.VendorWarrantyClaim;
import com.backend.Repository.VendorWarrantyClaimRepo;
import com.backend.Service.VendorWarrantyClaimService;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class VendorWarrantyClaimServiceImpl
implements VendorWarrantyClaimService {
    @Autowired
    private VendorWarrantyClaimRepo vendorWarrantyClaimRepo;

    public VendorWarrantyClaim saveWarrantyClaim(VendorWarrantyClaim vendorWarrantyClaim) {
        if (vendorWarrantyClaim.getVendorWarrantyClaimItems() != null) {
            vendorWarrantyClaim.getVendorWarrantyClaimItems().forEach(item -> item.setVendorWarrantyClaim(vendorWarrantyClaim));
        }
        return (VendorWarrantyClaim)this.vendorWarrantyClaimRepo.save((Object)vendorWarrantyClaim);
    }

    public List<VendorWarrantyClaim> getAllWarrantyClaims() {
        return this.vendorWarrantyClaimRepo.findAll();
    }

    public Optional<VendorWarrantyClaim> getWarrantyClaimById(Long id) {
        return this.vendorWarrantyClaimRepo.findById((Object)id);
    }

    public VendorWarrantyClaim updateWarrantyClaim(Long id, VendorWarrantyClaim vendorWarrantyClaim) {
        Optional existingWarrantyClaim = this.vendorWarrantyClaimRepo.findById((Object)id);
        if (existingWarrantyClaim.isPresent()) {
            VendorWarrantyClaim updatedWarrantyClaim = (VendorWarrantyClaim)existingWarrantyClaim.get();
            updatedWarrantyClaim.setVendor(vendorWarrantyClaim.getVendor());
            updatedWarrantyClaim.setReferenceNumber(vendorWarrantyClaim.getReferenceNumber());
            updatedWarrantyClaim.setDate(vendorWarrantyClaim.getDate());
            updatedWarrantyClaim.setStatus(vendorWarrantyClaim.getStatus());
            updatedWarrantyClaim.setTotalAmount(vendorWarrantyClaim.getTotalAmount());
            updatedWarrantyClaim.setUpdatedTotalAmount(vendorWarrantyClaim.getUpdatedTotalAmount());
            updatedWarrantyClaim.setUpdatedTotalUnits(vendorWarrantyClaim.getUpdatedTotalUnits());
            updatedWarrantyClaim.setTotalUnits(vendorWarrantyClaim.getTotalUnits());
            updatedWarrantyClaim.setReason(vendorWarrantyClaim.getReason());
            if (vendorWarrantyClaim.getVendorWarrantyClaimItems() != null) {
                vendorWarrantyClaim.getVendorWarrantyClaimItems().forEach(item -> item.setVendorWarrantyClaim(updatedWarrantyClaim));
                updatedWarrantyClaim.setVendorWarrantyClaimItems(vendorWarrantyClaim.getVendorWarrantyClaimItems());
            }
            if (vendorWarrantyClaim.getStockTransaction() != null) {
                vendorWarrantyClaim.getStockTransaction().forEach(item -> item.setVendorWarrantyClaim(updatedWarrantyClaim));
                updatedWarrantyClaim.setStockTransaction(vendorWarrantyClaim.getStockTransaction());
            }
            return (VendorWarrantyClaim)this.vendorWarrantyClaimRepo.save((Object)updatedWarrantyClaim);
        }
        throw new RuntimeException("Warranty Claim not found with ID: " + id);
    }

    public void deleteWarrantyClaim(Long id) {
        if (!this.vendorWarrantyClaimRepo.existsById((Object)id)) {
            throw new RuntimeException("Warranty Claim not found with ID: " + id);
        }
        this.vendorWarrantyClaimRepo.deleteById((Object)id);
    }

    public VendorWarrantyClaim updateWarrantyClaimStatus(Long id, Long newStatus) {
        Optional existingWarrantyClaim = this.vendorWarrantyClaimRepo.findById((Object)id);
        if (existingWarrantyClaim.isPresent()) {
            VendorWarrantyClaim warrantyClaim = (VendorWarrantyClaim)existingWarrantyClaim.get();
            warrantyClaim.setStatus(newStatus);
            return (VendorWarrantyClaim)this.vendorWarrantyClaimRepo.save((Object)warrantyClaim);
        }
        throw new RuntimeException("Warranty Claim not found with ID: " + id);
    }

    public List<VendorWarrantyClaim> getPendingOrders() {
        return this.vendorWarrantyClaimRepo.findByStatus(Long.valueOf(0L));
    }

    public List<VendorWarrantyClaim> getAcceptedOrders() {
        return this.vendorWarrantyClaimRepo.findByStatus(Long.valueOf(1L));
    }

    public List<VendorWarrantyClaim> getRejectedOrders() {
        return this.vendorWarrantyClaimRepo.findByStatus(Long.valueOf(2L));
    }

    public List<VendorWarrantyClaim> getShipOrders() {
        return this.vendorWarrantyClaimRepo.findByStatus(Long.valueOf(3L));
    }
}

