/*
 * Decompiled with CFR 0.152.
 */
package com.franchise.Controller;

import com.franchise.Entity.PurchaseDIOrder;
import com.franchise.Service.PurchaseDIOrderService;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/purchase-di-order"})
@CrossOrigin(origins={"http://localhost:3000", "http://fusionmastertech.com", "https://fusionmastertech.com", "http://www.fusionmastertech.com", "https://www.fusionmastertech.com"}, allowCredentials="true")
public class PurchaseDIOrderController {
    @Autowired
    private PurchaseDIOrderService purchaseDIOrderService;

    @PostMapping(value={"/save"})
    public ResponseEntity<PurchaseDIOrder> createPurchase(@RequestBody PurchaseDIOrder purchaseDIOrder) {
        PurchaseDIOrder savedOrderPurchase = this.purchaseDIOrderService.savePurchaseDIOrder(purchaseDIOrder);
        return new ResponseEntity((Object)savedOrderPurchase, (HttpStatusCode)HttpStatus.CREATED);
    }

    @GetMapping(value={"/getall"})
    public ResponseEntity<List<PurchaseDIOrder>> getAllPurchases() {
        List orders = this.purchaseDIOrderService.getAllPurchaseDIOrders();
        return new ResponseEntity((Object)orders, (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/get/{id}"})
    public ResponseEntity<Optional<PurchaseDIOrder>> getPurchaseOrderById(@PathVariable Long id) {
        Optional orders = this.purchaseDIOrderService.getPurchaseDIOrderById(id);
        return orders.isPresent() ? new ResponseEntity((Object)orders, (HttpStatusCode)HttpStatus.OK) : new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    @PutMapping(value={"/update/{id}"})
    public ResponseEntity<PurchaseDIOrder> updatePurchaseOrder(@PathVariable Long id, @RequestBody PurchaseDIOrder purchaseOrder) {
        PurchaseDIOrder updatedOrder = this.purchaseDIOrderService.updatePurchaseDIOrder(id, purchaseOrder);
        return updatedOrder != null ? new ResponseEntity((Object)updatedOrder, (HttpStatusCode)HttpStatus.OK) : new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    @DeleteMapping(value={"/delete/{id}"})
    public ResponseEntity<Void> deletePurchaseOrder(@PathVariable Long id) {
        this.purchaseDIOrderService.deletePurchaseDIOrder(id);
        return new ResponseEntity((HttpStatusCode)HttpStatus.NO_CONTENT);
    }

    @GetMapping(value={"/getAllOrderIds"})
    public ResponseEntity<List<String>> getAllOrderIds() {
        List orderIds = this.purchaseDIOrderService.getAllOrderIds();
        return new ResponseEntity((Object)orderIds, (HttpStatusCode)HttpStatus.OK);
    }
}

