/*
 * Decompiled with CFR 0.152.
 */
package com.franchise.Controller;

import com.franchise.Entity.PurchaseOrder;
import com.franchise.Entity.PurchaseReturn;
import com.franchise.Service.PurchaseReturnService;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/purchasereturn"})
@CrossOrigin(origins={"http://fusionmastertech.com", "https://fusionmastertech.com", "http://localhost:3000", "http://localhost:3001"}, allowCredentials="true")
public class PurchaseReturnController {
    @Autowired
    private PurchaseReturnService purchaseReturnService;

    @PostMapping(value={"/save"})
    public ResponseEntity<PurchaseReturn> createPurchase(@RequestBody PurchaseReturn purchaseReturn) {
        PurchaseReturn savedPurchaseReturn = this.purchaseReturnService.savePurchaseReturn(purchaseReturn);
        return new ResponseEntity((Object)savedPurchaseReturn, (HttpStatusCode)HttpStatus.CREATED);
    }

    @GetMapping(value={"/getall"})
    public ResponseEntity<List<PurchaseReturn>> getAllPurchaseReturns() {
        List returns = this.purchaseReturnService.getAllPurchaseReturns();
        return new ResponseEntity((Object)returns, (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/get/{id}"})
    public ResponseEntity<Optional<PurchaseReturn>> getPurchaseOrderById(@PathVariable Long id) {
        Optional returns = this.purchaseReturnService.getPurchaseReturnById(id);
        return returns.isPresent() ? new ResponseEntity((Object)returns, (HttpStatusCode)HttpStatus.OK) : new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    @PutMapping(value={"/update/{id}"})
    public ResponseEntity<PurchaseReturn> updatePurchaseOrder(@PathVariable Long id, @RequestBody PurchaseReturn purchaseReturn) {
        PurchaseReturn updatedOrder = this.purchaseReturnService.updatePurchaseReturn(id, purchaseReturn);
        return updatedOrder != null ? new ResponseEntity((Object)updatedOrder, (HttpStatusCode)HttpStatus.OK) : new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    @DeleteMapping(value={"/delete/{id}"})
    public ResponseEntity<Void> deletePurchaseOrder(@PathVariable Long id) {
        this.purchaseReturnService.deletePurchaseReturn(id);
        return new ResponseEntity((HttpStatusCode)HttpStatus.NO_CONTENT);
    }

    @GetMapping(value={"/getAllOrderIds"})
    public ResponseEntity<List<String>> getAllReturnIds() {
        List returnIds = this.purchaseReturnService.getAllReturnIds();
        return new ResponseEntity((Object)returnIds, (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/getPoDataById/{id}"})
    public ResponseEntity<PurchaseReturn> getPurchaseOrderByPoId(@PathVariable String id) {
        Optional order = this.purchaseReturnService.getPurchaseReturnByPRId(id);
        return order.map(value -> new ResponseEntity(value, (HttpStatusCode)HttpStatus.OK)).orElseGet(() -> new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND));
    }

    @GetMapping(value={"/getOrderIdsByStatus/{status}"})
    public ResponseEntity<List<String>> getOrderIdsByStatus(@PathVariable Long status) {
        List orderIds = this.purchaseReturnService.getPurchaseReturnIdsByStatus(status);
        return new ResponseEntity((Object)orderIds, (HttpStatusCode)HttpStatus.OK);
    }

    @PutMapping(value={"/updateStatus/{id}"})
    public ResponseEntity<PurchaseReturn> updatePurchaseStatus(@PathVariable Long id, @RequestBody PurchaseOrder updatedStatus) {
        Optional existingOrder = this.purchaseReturnService.getPurchaseReturnById(id);
        if (existingOrder.isPresent()) {
            PurchaseReturn purchaseReturn = (PurchaseReturn)existingOrder.get();
            purchaseReturn.setStatus(updatedStatus.getStatus());
            PurchaseReturn updatedOrder = this.purchaseReturnService.savePurchaseReturn(purchaseReturn);
            return new ResponseEntity((Object)updatedOrder, (HttpStatusCode)HttpStatus.OK);
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    @GetMapping(value={"/getPendingOrders"})
    public ResponseEntity<List<PurchaseReturn>> getPendingOrders() {
        List pendingOrders = this.purchaseReturnService.getPendingOrders();
        return new ResponseEntity((Object)pendingOrders, (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/getAcceptedOrders"})
    public ResponseEntity<List<PurchaseReturn>> getAcceptedOrders() {
        List acceptedOrders = this.purchaseReturnService.getAcceptedOrders();
        return new ResponseEntity((Object)acceptedOrders, (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/getRejectedOrders"})
    public ResponseEntity<List<PurchaseReturn>> getRejectedOrders() {
        List rejectedOrders = this.purchaseReturnService.getRejectedOrders();
        return new ResponseEntity((Object)rejectedOrders, (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/getShipOrders"})
    public ResponseEntity<List<PurchaseReturn>> getShipOrders() {
        List shipOrders = this.purchaseReturnService.getShipOrders();
        return new ResponseEntity((Object)shipOrders, (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/getTotalShippedItems/{purchaseOrderId}"})
    public ResponseEntity<Long> getTotalShippedItems(@PathVariable String purchaseReturnId) {
        Long totalShippedItems = this.purchaseReturnService.getTotalShippedItems(purchaseReturnId);
        return ResponseEntity.ok((Object)totalShippedItems);
    }
}

