/*
 * Decompiled with CFR 0.152.
 */
package com.franchise.Controller;

import com.franchise.Entity.Tax;
import com.franchise.Service.TaxService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/tax"})
@CrossOrigin(origins={"http://fusionmastertech.com", "https://fusionmastertech.com", "http://localhost:3000", "http://localhost:3001"}, allowCredentials="true")
public class TaxController {
    @Autowired
    private TaxService taxService;

    @GetMapping(value={"/getall"})
    public ResponseEntity<List<Tax>> getAllTaxes() {
        return ResponseEntity.ok((Object)this.taxService.getAllTaxes());
    }

    @GetMapping(value={"/get/{id}"})
    public ResponseEntity<Tax> getTaxById(@PathVariable Long id) {
        try {
            return ResponseEntity.ok((Object)this.taxService.getTaxById(id));
        }
        catch (RuntimeException e) {
            return ResponseEntity.notFound().build();
        }
    }

    @PostMapping(value={"/save"})
    public ResponseEntity<Tax> createTax(@RequestBody Tax tax) {
        return ResponseEntity.ok((Object)this.taxService.createTax(tax));
    }

    @PutMapping(value={"/update/{id}"})
    public ResponseEntity<Tax> updateTax(@PathVariable Long id, @RequestBody Tax taxDetails) {
        try {
            return ResponseEntity.ok((Object)this.taxService.updateTax(id, taxDetails));
        }
        catch (RuntimeException e) {
            return ResponseEntity.notFound().build();
        }
    }

    @DeleteMapping(value={"/delete/{id}"})
    public ResponseEntity<String> deleteTax(@PathVariable Long id) {
        try {
            this.taxService.deleteTax(id);
            return ResponseEntity.ok((Object)"Tax deleted successfully");
        }
        catch (RuntimeException e) {
            return ResponseEntity.notFound().build();
        }
    }
}

