/*
 * Decompiled with CFR 0.152.
 */
package com.franchise.Controller;

import com.franchise.Entity.Vendor;
import com.franchise.Service.VendorService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/vendor"})
@CrossOrigin(origins={"http://fusionmastertech.com", "https://fusionmastertech.com", "http://localhost:3000", "http://localhost:3001"}, allowCredentials="true")
public class VendorController {
    @Autowired
    private VendorService vendorService;

    @PostMapping(value={"/save"})
    public ResponseEntity<Vendor> createVendor(@RequestBody Vendor vendor) {
        Vendor savedVendor = this.vendorService.saveVendor(vendor);
        return ResponseEntity.ok((Object)savedVendor);
    }

    @GetMapping(value={"/getall"})
    public ResponseEntity<List<Vendor>> getAllVendors() {
        List vendors = this.vendorService.getAllVendors();
        return ResponseEntity.ok((Object)vendors);
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<Vendor> getVendorById(@PathVariable Long id) {
        Vendor vendor = this.vendorService.getVendorById(id);
        if (vendor != null) {
            return ResponseEntity.ok((Object)vendor);
        }
        return ResponseEntity.notFound().build();
    }

    @PutMapping(value={"/update/{id}"})
    public ResponseEntity<Vendor> updateVendor(@PathVariable Long id, @RequestBody Vendor updatedVendor) {
        Vendor vendor = this.vendorService.updateVendor(id, updatedVendor);
        if (vendor != null) {
            return ResponseEntity.ok((Object)vendor);
        }
        return ResponseEntity.notFound().build();
    }

    @DeleteMapping(value={"/delete/{id}"})
    public ResponseEntity<Void> deleteVendorById(@PathVariable Long id) {
        this.vendorService.deleteVendorById(id);
        return ResponseEntity.noContent().build();
    }

    @GetMapping(value={"/firmname/email/{email}"})
    public ResponseEntity<Map<String, String>> getFirmNameByEmail(@PathVariable String email) {
        Optional firmName = this.vendorService.findFirmNameByEmail(email);
        if (firmName.isPresent()) {
            HashMap<String, String> response = new HashMap<String, String>();
            response.put("firmName", (String)firmName.get());
            return ResponseEntity.ok(response);
        }
        return ResponseEntity.notFound().build();
    }
}

