/*
 * Decompiled with CFR 0.152.
 */
package com.franchise.ServiceImpl;

import com.franchise.Entity.Customer;
import com.franchise.Repository.CustomerRepo;
import com.franchise.Service.CustomerService;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CustomerImpl
implements CustomerService {
    @Autowired
    private CustomerRepo customerrepo;

    public Customer saveCustomer(Customer customer) {
        return (Customer)this.customerrepo.save((Object)customer);
    }

    public List<Customer> getAllCustomers() {
        return this.customerrepo.findAll();
    }

    public Customer updateCustomer(Long CustomerId, Customer updatedCustomer) {
        Optional existingCustomerOptional = this.customerrepo.findById((Object)CustomerId);
        if (existingCustomerOptional.isPresent()) {
            Customer existingCustomer = (Customer)existingCustomerOptional.get();
            existingCustomer.setPrefix(updatedCustomer.getPrefix());
            existingCustomer.setFirstName(updatedCustomer.getFirstName());
            existingCustomer.setLastName(updatedCustomer.getLastName());
            existingCustomer.setEmail(updatedCustomer.getEmail());
            existingCustomer.setActive(updatedCustomer.isActive());
            existingCustomer.setTaxNumber(updatedCustomer.getTaxNumber());
            existingCustomer.setOpeningBalance(updatedCustomer.getOpeningBalance());
            existingCustomer.setPayTerm(updatedCustomer.getPayTerm());
            existingCustomer.setPayTermType(updatedCustomer.getPayTermType());
            existingCustomer.setCreditLimit(updatedCustomer.getCreditLimit());
            existingCustomer.setLanguage(updatedCustomer.getLanguage());
            existingCustomer.setDateOfBirth(updatedCustomer.getDateOfBirth());
            existingCustomer.setGender(updatedCustomer.getGender());
            existingCustomer.setMaritalStatus(updatedCustomer.getMaritalStatus());
            existingCustomer.setBloodGroup(updatedCustomer.getBloodGroup());
            existingCustomer.setMobileNumber(updatedCustomer.getMobileNumber());
            existingCustomer.setAlternateContactNumber(updatedCustomer.getAlternateContactNumber());
            existingCustomer.setCustomField1(updatedCustomer.getCustomField1());
            existingCustomer.setCustomField2(updatedCustomer.getCustomField2());
            existingCustomer.setCustomField3(updatedCustomer.getCustomField3());
            existingCustomer.setCustomField4(updatedCustomer.getCustomField4());
            existingCustomer.setIdProofName(updatedCustomer.getIdProofName());
            existingCustomer.setIdProofNumber(updatedCustomer.getIdProofNumber());
            existingCustomer.setCountry(updatedCustomer.getCountry());
            existingCustomer.setState(updatedCustomer.getState());
            existingCustomer.setCity(updatedCustomer.getCity());
            existingCustomer.setZipCode(updatedCustomer.getZipCode());
            existingCustomer.setLandmark(updatedCustomer.getLandmark());
            existingCustomer.setStreetName(updatedCustomer.getStreetName());
            existingCustomer.setBuildingNumber(updatedCustomer.getBuildingNumber());
            existingCustomer.setOccupation(updatedCustomer.getOccupation());
            return (Customer)this.customerrepo.save((Object)existingCustomer);
        }
        return null;
    }

    public Customer getCustomerById(Long id) {
        Optional customers = this.customerrepo.findById((Object)id);
        return customers.orElse(null);
    }

    public void deleteCustomerById(Long id) {
        this.customerrepo.deleteById((Object)id);
    }

    public boolean isActiveUser(String email) {
        Optional customer = this.customerrepo.findByEmail(email);
        return customer.map(Customer::isActive).orElse(false);
    }

    public Optional<String> getUserName(String email) {
        return this.customerrepo.findByEmail(email).map(customer -> customer.getFirstName() + " " + customer.getLastName());
    }

    public Optional<String> findCustomerByEmail(String email) {
        return this.customerrepo.findByEmail(email).map(Customer::getEmail);
    }
}

