/*
 * Decompiled with CFR 0.152.
 */
package com.franchise.ServiceImpl;

import com.franchise.Entity.Product;
import com.franchise.Repository.ProductRepo;
import com.franchise.Service.ProductService;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ProductServiceImpl
implements ProductService {
    @Autowired
    private ProductRepo productRepo;

    public Product saveProduct(Product product) {
        boolean exists = this.productRepo.existsByProductIdAndVariationIdAndProductNameAndVariationName(product.getProductId(), product.getVariationId(), product.getProductName(), product.getVariationName());
        if (exists) {
            return null;
        }
        return (Product)this.productRepo.save((Object)product);
    }

    public Product updateProduct(Long id, Product updatedProduct) {
        Optional existing = this.productRepo.findById((Object)id);
        if (existing.isPresent()) {
            Product product = (Product)existing.get();
            product.setProductId(updatedProduct.getProductId());
            product.setVariationId(updatedProduct.getVariationId());
            product.setProductName(updatedProduct.getProductName());
            product.setVariationName(updatedProduct.getVariationName());
            product.setPrice(updatedProduct.getPrice());
            return (Product)this.productRepo.save((Object)product);
        }
        return null;
    }

    public void deleteProduct(Long id) {
        this.productRepo.deleteById((Object)id);
    }

    public Optional<Product> getProductById(Long id) {
        return this.productRepo.findById((Object)id);
    }

    public List<Product> getAllProducts() {
        return this.productRepo.findAll();
    }

    public List<Product> findByProductId(Long productId) {
        return this.productRepo.findByProductId(productId);
    }

    public List<Product> findByVariationId(Long variationId) {
        return this.productRepo.findByVariationId(variationId);
    }

    public List<Product> findByProductName(String productName) {
        return this.productRepo.findByProductName(productName);
    }

    public List<Product> findByVariationName(String variationName) {
        return this.productRepo.findByVariationName(variationName);
    }

    public boolean existsByAllFields(Long productId, Long variationId, String productName, String variationName) {
        return this.productRepo.existsByProductIdAndVariationIdAndProductNameAndVariationName(productId, variationId, productName, variationName);
    }
}

