/*
 * Decompiled with CFR 0.152.
 */
package com.franchise.ServiceImpl;

import com.franchise.Entity.PurchaseDIItem;
import com.franchise.Entity.PurchaseDIOrder;
import com.franchise.Entity.ShippingDIDetails;
import com.franchise.Entity.StockTransaction;
import com.franchise.Repository.PurchaseDIOrderRepo;
import com.franchise.Service.PurchaseDIOrderService;
import jakarta.transaction.Transactional;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PurchaseDIOrderServiceImpl
implements PurchaseDIOrderService {
    @Autowired
    private PurchaseDIOrderRepo purchaseOrderRepo;

    @Transactional
    public PurchaseDIOrder savePurchaseDIOrder(PurchaseDIOrder purchaseDIOrder) {
        if (purchaseDIOrder.getPurchaseDIItem() != null) {
            for (PurchaseDIItem item : purchaseDIOrder.getPurchaseDIItem()) {
                item.setPurchaseDIOrder(purchaseDIOrder);
            }
        }
        if (purchaseDIOrder.getShippingDIDetails() != null) {
            for (ShippingDIDetails ship : purchaseDIOrder.getShippingDIDetails()) {
                ship.setPurchaseDIOrder(purchaseDIOrder);
            }
        }
        if (purchaseDIOrder.getStockTransactions() != null) {
            for (StockTransaction stock : purchaseDIOrder.getStockTransactions()) {
                stock.setPurchaseDIOrder(purchaseDIOrder);
            }
        }
        return (PurchaseDIOrder)this.purchaseOrderRepo.save((Object)purchaseDIOrder);
    }

    public List<PurchaseDIOrder> getAllPurchaseDIOrders() {
        return this.purchaseOrderRepo.findAll();
    }

    public Optional<PurchaseDIOrder> getPurchaseDIOrderById(Long id) {
        return this.purchaseOrderRepo.findById((Object)id);
    }

    @Transactional
    public PurchaseDIOrder updatePurchaseDIOrder(Long id, PurchaseDIOrder updatedPurchaseDIOrder) {
        Optional existingOrderOptional = this.purchaseOrderRepo.findById((Object)id);
        if (existingOrderOptional.isPresent()) {
            PurchaseDIOrder existingOrder = (PurchaseDIOrder)existingOrderOptional.get();
            existingOrder.setStatus(updatedPurchaseDIOrder.getStatus());
            existingOrder.setVendor(updatedPurchaseDIOrder.getVendor());
            existingOrder.setAddedBy(updatedPurchaseDIOrder.getAddedBy());
            existingOrder.setReferenceNumber(updatedPurchaseDIOrder.getReferenceNumber());
            existingOrder.setOrderDate(updatedPurchaseDIOrder.getOrderDate());
            existingOrder.setPayTermNumber(updatedPurchaseDIOrder.getPayTermNumber());
            existingOrder.setPayTermType(updatedPurchaseDIOrder.getPayTermType());
            existingOrder.setLocation(updatedPurchaseDIOrder.getLocation());
            existingOrder.setFile(updatedPurchaseDIOrder.getFile());
            existingOrder.setTotalItems(updatedPurchaseDIOrder.getTotalItems());
            existingOrder.setNetTotalAmount(updatedPurchaseDIOrder.getNetTotalAmount());
            existingOrder.setDiscountType(updatedPurchaseDIOrder.getDiscountType());
            existingOrder.setDiscountAmount(updatedPurchaseDIOrder.getDiscountAmount());
            existingOrder.setPurchaseTax(updatedPurchaseDIOrder.getPurchaseTax());
            existingOrder.setTaxAmount(updatedPurchaseDIOrder.getTaxAmount());
            existingOrder.setAdditionalNotes(updatedPurchaseDIOrder.getAdditionalNotes());
            if (updatedPurchaseDIOrder.getPurchaseDIItem() != null) {
                existingOrder.getPurchaseDIItem().clear();
                for (PurchaseDIItem item : updatedPurchaseDIOrder.getPurchaseDIItem()) {
                    item.setPurchaseDIOrder(existingOrder);
                    existingOrder.getPurchaseDIItem().add(item);
                }
            }
            if (updatedPurchaseDIOrder.getShippingDIDetails() != null) {
                existingOrder.getShippingDIDetails().clear();
                for (ShippingDIDetails ship : updatedPurchaseDIOrder.getShippingDIDetails()) {
                    ship.setPurchaseDIOrder(existingOrder);
                    existingOrder.getShippingDIDetails().add(ship);
                }
            }
            if (updatedPurchaseDIOrder.getStockTransactions() != null) {
                existingOrder.getStockTransactions().clear();
                for (StockTransaction stock : updatedPurchaseDIOrder.getStockTransactions()) {
                    stock.setPurchaseDIOrder(existingOrder);
                    existingOrder.getStockTransactions().add(stock);
                }
            }
            return (PurchaseDIOrder)this.purchaseOrderRepo.save((Object)existingOrder);
        }
        return null;
    }

    public void deletePurchaseDIOrder(Long id) {
        if (this.purchaseOrderRepo.existsById((Object)id)) {
            this.purchaseOrderRepo.deleteById((Object)id);
        }
    }

    public List<String> getAllOrderIds() {
        return null;
    }
}

