/*
 * Decompiled with CFR 0.152.
 */
package com.franchise.ServiceImpl;

import com.franchise.Entity.PaymentAccount;
import com.franchise.Entity.SaleReturn;
import com.franchise.Entity.SaleReturnItem;
import com.franchise.Entity.ShippingSaleReturnDetails;
import com.franchise.Entity.StockTransaction;
import com.franchise.Entity.Transaction;
import com.franchise.Repository.PaymentAccountRepo;
import com.franchise.Repository.SaleReturnRepo;
import com.franchise.Service.SaleReturnService;
import java.math.BigDecimal;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SaleReturnServiceImpl
implements SaleReturnService {
    @Autowired
    SaleReturnRepo saleReturnRepo;
    @Autowired
    private PaymentAccountRepo paymentAccountRepo;

    public SaleReturn saveSaleReturn(SaleReturn saleReturn) {
        if (saleReturn.getSaleReturnItem() != null) {
            for (SaleReturnItem item : saleReturn.getSaleReturnItem()) {
                item.setSaleReturn(saleReturn);
            }
        }
        if (saleReturn.getShippingSaleReturnDetails() != null) {
            for (ShippingSaleReturnDetails ship : saleReturn.getShippingSaleReturnDetails()) {
                ship.setSaleReturn(saleReturn);
            }
        }
        if (saleReturn.getStockTransaction() != null) {
            for (StockTransaction stock : saleReturn.getStockTransaction()) {
                stock.setSaleReturn(saleReturn);
            }
        }
        if (saleReturn.getTransaction() != null) {
            for (Transaction transaction : saleReturn.getTransaction()) {
                BigDecimal previousBalance;
                transaction.setSaleReturn(saleReturn);
                if (transaction.getPaymentAccount() == null && transaction.getPaymentAccountId() != null) {
                    PaymentAccount paymentAccount = (PaymentAccount)this.paymentAccountRepo.findById((Object)transaction.getPaymentAccountId()).orElseThrow(() -> new RuntimeException("Payment Account not found for ID: " + transaction.getPaymentAccountId()));
                    transaction.setPaymentAccount(paymentAccount);
                }
                if (transaction.getPaymentAccount() == null) {
                    throw new RuntimeException("Transaction must be associated with a valid Payment Account.");
                }
                BigDecimal newBalance = previousBalance = transaction.getPaymentAccount().getBalance() != null ? transaction.getPaymentAccount().getBalance() : BigDecimal.ZERO;
                switch (transaction.getTransactionType().toLowerCase()) {
                    case "deposit": 
                    case "purchase": 
                    case "salereturn": 
                    case "opening_balance": {
                        newBalance = previousBalance.add(transaction.getAmount());
                        break;
                    }
                    case "sale": 
                    case "expense": {
                        newBalance = previousBalance.subtract(transaction.getAmount());
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unknown transaction type: " + transaction.getTransactionType());
                    }
                }
                transaction.setBalance(newBalance);
                transaction.getPaymentAccount().setBalance(newBalance);
                this.paymentAccountRepo.save((Object)transaction.getPaymentAccount());
            }
        }
        return (SaleReturn)this.saleReturnRepo.save((Object)saleReturn);
    }

    public List<SaleReturn> getAllSaleReturn() {
        return this.saleReturnRepo.findAll();
    }

    public Optional<SaleReturn> getSaleReturnById(Long id) {
        return this.saleReturnRepo.findById((Object)id);
    }

    public SaleReturn updateSaleReturn(Long id, SaleReturn saleReturn) {
        Optional existingOrder = this.saleReturnRepo.findById((Object)id);
        if (existingOrder.isPresent()) {
            SaleReturn purchaseDIOrder = (SaleReturn)existingOrder.get();
            purchaseDIOrder.setOrderId(saleReturn.getOrderId());
            purchaseDIOrder.setOrderRefernceNumber(saleReturn.getOrderRefernceNumber());
            purchaseDIOrder.setReferenceNumber(saleReturn.getReferenceNumber());
            purchaseDIOrder.setOrderedBy(saleReturn.getOrderedBy());
            purchaseDIOrder.setAddedBy(saleReturn.getAddedBy());
            purchaseDIOrder.setOrderDate(saleReturn.getOrderDate());
            purchaseDIOrder.setSaleDate(saleReturn.getSaleDate());
            purchaseDIOrder.setPayTermNumber(saleReturn.getPayTermNumber());
            purchaseDIOrder.setPayTermType(saleReturn.getPayTermType());
            purchaseDIOrder.setLocation(saleReturn.getLocation());
            purchaseDIOrder.setNetTotalAmount(saleReturn.getNetTotalAmount());
            purchaseDIOrder.setDiscountType(saleReturn.getDiscountType());
            purchaseDIOrder.setDiscountAmount(saleReturn.getDiscountAmount());
            purchaseDIOrder.setSaleTax(saleReturn.getSaleTax());
            purchaseDIOrder.setTaxAmount(saleReturn.getTaxAmount());
            purchaseDIOrder.setTotalItems(saleReturn.getTotalItems());
            purchaseDIOrder.setAdditionalNotes(saleReturn.getAdditionalNotes());
            purchaseDIOrder.getSaleReturnItem().clear();
            purchaseDIOrder.getSaleReturnItem().addAll(saleReturn.getSaleReturnItem());
            for (SaleReturnItem item : purchaseDIOrder.getSaleReturnItem()) {
                item.setSaleReturn(saleReturn);
            }
            return (SaleReturn)this.saleReturnRepo.save((Object)purchaseDIOrder);
        }
        return null;
    }

    public void deleteSaleReturn(Long id) {
        if (this.saleReturnRepo.existsById((Object)id)) {
            this.saleReturnRepo.deleteById((Object)id);
        }
    }

    public List<String> getAllReturnIds() {
        return null;
    }

    public Optional<SaleReturn> getSaleOrderById(String orderId) {
        return Optional.ofNullable(this.saleReturnRepo.findByOrderId(orderId));
    }
}

