/*
 * Decompiled with CFR 0.152.
 */
package com.franchise.ServiceImpl;

import com.franchise.Entity.Sale;
import com.franchise.Entity.SaleItems;
import com.franchise.Entity.StockTransaction;
import com.franchise.Repository.SaleRepo;
import com.franchise.Service.IdGenerator;
import com.franchise.Service.SaleService;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SaleServiceImpl
implements SaleService {
    @Autowired
    private SaleRepo saleRepo;
    @Autowired
    private IdGenerator idGenerator;

    public Sale createSale(Sale sale) {
        if (sale.getSaleItems() != null) {
            sale.setIdGenerator(this.idGenerator);
            for (SaleItems items : sale.getSaleItems()) {
                items.setSale(sale);
            }
        }
        if (sale.getStockTransaction() != null) {
            for (StockTransaction stock : sale.getStockTransaction()) {
                stock.setSale(sale);
            }
        }
        return (Sale)this.saleRepo.save((Object)sale);
    }

    public List<Sale> getAllSales() {
        return this.saleRepo.findAll();
    }

    public Optional<Sale> getSaleById(Long id) {
        return this.saleRepo.findById((Object)id);
    }

    public Sale updateSale(Long id, Sale saleDetails) {
        Optional existingSale = this.saleRepo.findById((Object)id);
        if (existingSale.isPresent()) {
            Sale sale = (Sale)existingSale.get();
            sale.setCustomer(saleDetails.getCustomer());
            sale.setPayTermNumber(saleDetails.getPayTermNumber());
            sale.setPayTermType(saleDetails.getPayTermType());
            sale.setSaleDate(saleDetails.getSaleDate());
            sale.setInvoiceNo(saleDetails.getInvoiceNo());
            sale.setDiscountType(saleDetails.getDiscountType());
            sale.setDiscountAmount(saleDetails.getDiscountAmount());
            sale.setSaleTax(saleDetails.getSaleTax());
            sale.setTaxAmount(saleDetails.getTaxAmount());
            sale.setSaleNotes(saleDetails.getSaleNotes());
            sale.setShippingDetails(saleDetails.getShippingDetails());
            sale.setShippingCharges(saleDetails.getShippingCharges());
            sale.setShippingStatus(saleDetails.getShippingStatus());
            sale.setDeliveredTo(saleDetails.getDeliveredTo());
            sale.setDeliveryPerson(saleDetails.getDeliveryPerson());
            sale.setNetTotalAmount(saleDetails.getNetTotalAmount());
            sale.getSaleItems().clear();
            sale.getSaleItems().addAll(saleDetails.getSaleItems());
            for (SaleItems item : sale.getSaleItems()) {
                item.setSale(sale);
            }
            return (Sale)this.saleRepo.save((Object)sale);
        }
        throw new RuntimeException("Sale not found with id " + id);
    }

    public void deleteSale(Long id) {
        if (!this.saleRepo.existsById((Object)id)) {
            throw new RuntimeException("Sale not found with id " + id);
        }
        this.saleRepo.deleteById((Object)id);
    }

    public List<String> getAllOrderIds() {
        return this.saleRepo.findAll().stream().map(Sale::getSaleOrderId).collect(Collectors.toList());
    }

    public Optional<Sale> getSaleOrderById(String saleOrderId) {
        return Optional.ofNullable(this.saleRepo.findBysaleOrderId(saleOrderId));
    }
}

