/*
 * Decompiled with CFR 0.152.
 */
package com.franchise.ServiceImpl;

import com.franchise.Entity.StockTransaction;
import com.franchise.Repository.StockTransactionRepo;
import com.franchise.Service.StockTransactionService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class StockTransactionServiceImpl
implements StockTransactionService {
    @Autowired
    private StockTransactionRepo stockTransactionRepo;

    public List<StockTransaction> saveStockTransactions(List<StockTransaction> stockTransactions) {
        return this.stockTransactionRepo.saveAll(stockTransactions);
    }

    public List<StockTransaction> getTransactionsByProduct(Long productId) {
        return this.stockTransactionRepo.findByProductId(productId);
    }

    public List<StockTransaction> getTransactionsByVariation(Long variationId) {
        return this.stockTransactionRepo.findByVariationId(variationId);
    }

    public List<StockTransaction> getAllTransactions() {
        return this.stockTransactionRepo.findAll();
    }

    public List<StockTransaction> getTransactionsByProductAndVariation(Long productId, Long variationId) {
        return this.stockTransactionRepo.findByProductIdAndVariationId(productId, variationId);
    }

    public int getCurrentStock(Long productId, Long variationId) {
        List transactions = this.stockTransactionRepo.findByProductIdAndVariationId(productId, variationId);
        int currentStock = 0;
        for (StockTransaction transaction : transactions) {
            switch (transaction.getTransactionType()) {
                case "di_purchase": {
                    currentStock += transaction.getQuantity();
                    break;
                }
                case "po_purchase": {
                    currentStock += transaction.getQuantity();
                    break;
                }
                case "open_stock": {
                    currentStock += transaction.getQuantity();
                    break;
                }
                case "sale": {
                    currentStock -= transaction.getQuantity();
                    break;
                }
                case "purchase_return": {
                    currentStock -= transaction.getQuantity();
                    break;
                }
                case "sale_return": {
                    currentStock += transaction.getQuantity();
                    break;
                }
                case "adjustment": {
                    currentStock -= transaction.getQuantity();
                    break;
                }
                case "warranty_claimed": {
                    currentStock += transaction.getQuantity();
                    break;
                }
                case "warranty_replaced": {
                    currentStock -= transaction.getQuantity();
                    break;
                }
                case "warranty_return": {
                    currentStock -= transaction.getQuantity();
                }
            }
        }
        return currentStock;
    }

    public int getCurrentStockByProduct(Long productId) {
        List transactions = this.stockTransactionRepo.findByProductId(productId);
        int currentStock = 0;
        for (StockTransaction transaction : transactions) {
            switch (transaction.getTransactionType()) {
                case "po_purchase": {
                    currentStock += transaction.getQuantity();
                    break;
                }
                case "di_purchase": {
                    currentStock += transaction.getQuantity();
                    break;
                }
                case "open_stock": {
                    currentStock += transaction.getQuantity();
                    break;
                }
                case "sale": {
                    currentStock -= transaction.getQuantity();
                    break;
                }
                case "purchase_return": {
                    currentStock -= transaction.getQuantity();
                    break;
                }
                case "sale_return": {
                    currentStock += transaction.getQuantity();
                    break;
                }
                case "adjustment": {
                    currentStock -= transaction.getQuantity();
                    break;
                }
                case "warranty_claimed": {
                    currentStock += transaction.getQuantity();
                    break;
                }
                case "warranty_replaced": {
                    currentStock -= transaction.getQuantity();
                    break;
                }
                case "warranty_return": {
                    currentStock -= transaction.getQuantity();
                }
            }
        }
        return currentStock;
    }

    public int getCurrentStockByVariations(Long variationId) {
        List transactions = this.stockTransactionRepo.findByVariationId(variationId);
        int currentStock = 0;
        for (StockTransaction transaction : transactions) {
            switch (transaction.getTransactionType()) {
                case "purchase": {
                    currentStock += transaction.getQuantity();
                    break;
                }
                case "open_stock": {
                    currentStock += transaction.getQuantity();
                    break;
                }
                case "sale": {
                    currentStock -= transaction.getQuantity();
                    break;
                }
                case "purchase_return": {
                    currentStock -= transaction.getQuantity();
                    break;
                }
                case "sale_return": {
                    currentStock += transaction.getQuantity();
                    break;
                }
                case "adjustment": {
                    currentStock -= transaction.getQuantity();
                    break;
                }
                case "warranty_claimed": {
                    currentStock += transaction.getQuantity();
                    break;
                }
                case "warranty_replaced": {
                    currentStock -= transaction.getQuantity();
                    break;
                }
                case "warranty_return": {
                    currentStock -= transaction.getQuantity();
                }
            }
        }
        return currentStock;
    }
}

