/*
 * Decompiled with CFR 0.152.
 */
package com.franchise.ServiceImpl;

import com.franchise.Entity.WarrantyClaim;
import com.franchise.Repository.WarrantyClaimRepo;
import com.franchise.Service.WarrantyClaimService;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WarrantyClaimServiceImpl
implements WarrantyClaimService {
    @Autowired
    private WarrantyClaimRepo warrantyClaimRepo;

    public WarrantyClaim saveWarrantyClaim(WarrantyClaim warrantyClaim) {
        if (warrantyClaim.getWarrantyClaimItems() != null) {
            warrantyClaim.getWarrantyClaimItems().forEach(item -> item.setWarrantyClaim(warrantyClaim));
        }
        if (warrantyClaim.getStockTransaction() != null) {
            warrantyClaim.getStockTransaction().forEach(item -> item.setWarrantyClaim(warrantyClaim));
        }
        return (WarrantyClaim)this.warrantyClaimRepo.save((Object)warrantyClaim);
    }

    public List<WarrantyClaim> getAllWarrantyClaims() {
        return this.warrantyClaimRepo.findAll();
    }

    public Optional<WarrantyClaim> getWarrantyClaimById(Long id) {
        return this.warrantyClaimRepo.findById((Object)id);
    }

    public WarrantyClaim updateWarrantyClaim(Long id, WarrantyClaim warrantyClaim) {
        Optional existingWarrantyClaim = this.warrantyClaimRepo.findById((Object)id);
        if (existingWarrantyClaim.isPresent()) {
            WarrantyClaim updatedWarrantyClaim = (WarrantyClaim)existingWarrantyClaim.get();
            updatedWarrantyClaim.setBusinessLocation(warrantyClaim.getBusinessLocation());
            updatedWarrantyClaim.setReferenceNumber(warrantyClaim.getReferenceNumber());
            updatedWarrantyClaim.setDate(warrantyClaim.getDate());
            updatedWarrantyClaim.setStatus(warrantyClaim.getStatus());
            updatedWarrantyClaim.setTotalAmount(warrantyClaim.getTotalAmount());
            updatedWarrantyClaim.setTotalUnits(warrantyClaim.getTotalUnits());
            updatedWarrantyClaim.setReason(warrantyClaim.getReason());
            if (warrantyClaim.getWarrantyClaimItems() != null) {
                warrantyClaim.getWarrantyClaimItems().forEach(item -> item.setWarrantyClaim(updatedWarrantyClaim));
                updatedWarrantyClaim.setWarrantyClaimItems(warrantyClaim.getWarrantyClaimItems());
            }
            if (warrantyClaim.getStockTransaction() != null) {
                warrantyClaim.getStockTransaction().forEach(item -> item.setWarrantyClaim(updatedWarrantyClaim));
                updatedWarrantyClaim.setStockTransaction(warrantyClaim.getStockTransaction());
            }
            return (WarrantyClaim)this.warrantyClaimRepo.save((Object)updatedWarrantyClaim);
        }
        throw new RuntimeException("Warranty Claim not found with ID: " + id);
    }

    public void deleteWarrantyClaim(Long id) {
        if (!this.warrantyClaimRepo.existsById((Object)id)) {
            throw new RuntimeException("Warranty Claim not found with ID: " + id);
        }
        this.warrantyClaimRepo.deleteById((Object)id);
    }

    public WarrantyClaim updateWarrantyClaimStatus(Long id, Long newStatus) {
        Optional existingWarrantyClaim = this.warrantyClaimRepo.findById((Object)id);
        if (existingWarrantyClaim.isPresent()) {
            WarrantyClaim warrantyClaim = (WarrantyClaim)existingWarrantyClaim.get();
            warrantyClaim.setStatus(newStatus);
            return (WarrantyClaim)this.warrantyClaimRepo.save((Object)warrantyClaim);
        }
        throw new RuntimeException("Warranty Claim not found with ID: " + id);
    }
}

